/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.VendorCodeConverter;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MapVendorCodeConverter
implements VendorCodeConverter {
    private final Map<Long, Long> ckkGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckkVendorToGenericMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmVendorToGenericMap = new HashMap<Long, Long>();

    public MapVendorCodeConverter(Map<Long, Long> ckkGenericToVendorMap, Map<Long, Long> ckmGenericToVendorMap) {
        MapVendorCodeConverter.copyMapIfNotNull(ckkGenericToVendorMap, this.ckkGenericToVendorMap, this.ckkVendorToGenericMap);
        MapVendorCodeConverter.copyMapIfNotNull(ckmGenericToVendorMap, this.ckmGenericToVendorMap, this.ckmVendorToGenericMap);
    }

    public static MapVendorCodeConverter getInstance(Map<String, String> nameToCodeMap) {
        HashMap<Long, Long> ckkGenericToVendor = new HashMap<Long, Long>();
        HashMap<Long, Long> ckmGenericToVendor = new HashMap<Long, Long>();
        for (String name : nameToCodeMap.keySet()) {
            long genericCode;
            String codeStr = nameToCodeMap.get(name);
            long vendorCode = MapVendorCodeConverter.toLong(codeStr);
            String uname = name.trim().toUpperCase(Locale.ROOT);
            if (uname.startsWith("CKK_VENDOR_")) {
                switch (uname) {
                    case "CKK_VENDOR_SM2": {
                        genericCode = 0xFFFFF001L;
                        break;
                    }
                    case "CKK_VENDOR_SM4": {
                        genericCode = 0xFFFFF002L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown name " + name);
                    }
                }
                ckkGenericToVendor.put(genericCode, vendorCode);
                continue;
            }
            if (!uname.startsWith("CKM_VENDOR_")) continue;
            genericCode = Functions.mechanismStringToCode(uname);
            if (genericCode == -1L) {
                throw new IllegalArgumentException("unknown name " + name);
            }
            ckmGenericToVendor.put(genericCode, vendorCode);
        }
        return new MapVendorCodeConverter(ckkGenericToVendor, ckmGenericToVendor);
    }

    private static void copyMapIfNotNull(Map<Long, Long> source, Map<Long, Long> genericToVendorMap, Map<Long, Long> vendorToGenericMap) {
        Long vendor;
        if (source == null || source.isEmpty()) {
            return;
        }
        for (Long generic : source.keySet()) {
            if (generic == null || (vendor = source.get(generic)) == null) continue;
            genericToVendorMap.put(generic, vendor);
        }
        for (Long generic : genericToVendorMap.keySet()) {
            vendor = genericToVendorMap.get(generic);
            if (vendorToGenericMap.containsKey(vendor)) {
                throw new IllegalArgumentException("duplicated vendor code 0x" + Functions.toFullHex(vendor));
            }
            vendorToGenericMap.put(vendor, generic);
        }
    }

    private static long toLong(String str) {
        str = str.toLowerCase();
        boolean hex = false;
        if (str.startsWith("0x")) {
            str = str.substring(2);
            hex = true;
        }
        if (str.endsWith("ul")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("l")) {
            str = str.substring(0, str.length() - 1);
        }
        return Long.parseLong(str, hex ? 16 : 10);
    }

    @Override
    public long genericToVendorCKK(long ckk) {
        Long newValue = this.ckkGenericToVendorMap.get(ckk);
        return newValue == null ? ckk : newValue;
    }

    @Override
    public long vendorToGenericCKK(long ckk) {
        Long newValue = this.ckkVendorToGenericMap.get(ckk);
        return newValue == null ? ckk : newValue;
    }

    @Override
    public long genericToVendorCKM(long ckm) {
        Long newValue = this.ckmGenericToVendorMap.get(ckm);
        return newValue == null ? ckm : newValue;
    }

    @Override
    public long vendorToGenericCKM(long ckm) {
        Long newValue = this.ckmVendorToGenericMap.get(ckm);
        return newValue == null ? ckm : newValue;
    }
}

