/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.VendorCodeConverter;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.AesCtrParameters;
import iaik.pkcs.pkcs11.parameters.CCMParameters;
import iaik.pkcs.pkcs11.parameters.DHPkcsDeriveParameters;
import iaik.pkcs.pkcs11.parameters.EcDH1KeyDerivationParameters;
import iaik.pkcs.pkcs11.parameters.EcDH2KeyDerivationParameters;
import iaik.pkcs.pkcs11.parameters.ExtractParameters;
import iaik.pkcs.pkcs11.parameters.GCMParameters;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.parameters.MacGeneralParameters;
import iaik.pkcs.pkcs11.parameters.ObjectHandleParameters;
import iaik.pkcs.pkcs11.parameters.OpaqueParameters;
import iaik.pkcs.pkcs11.parameters.PBEParameters;
import iaik.pkcs.pkcs11.parameters.PKCS5PBKD2Parameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsOaepParameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsPssParameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialParameters;
import iaik.pkcs.pkcs11.parameters.SSL3MasterKeyDeriveParameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;
import iaik.pkcs.pkcs11.parameters.TLS12KeyMaterialParameters;
import iaik.pkcs.pkcs11.parameters.TLS12MasterKeyDeriveParameters;
import iaik.pkcs.pkcs11.parameters.TLSMacParameters;
import iaik.pkcs.pkcs11.parameters.TLSPRFParameters;
import iaik.pkcs.pkcs11.parameters.VersionParameters;
import iaik.pkcs.pkcs11.parameters.X942DH1KeyDerivationParameters;
import iaik.pkcs.pkcs11.parameters.X942DH2KeyDerivationParameters;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.PKCS11;

public class Session {
    private static final Method encrypt0;
    private static final Method encrypt1;
    private static final Method decrypt0;
    private static final Method decrypt1;
    private static final Field field_CK_MECHANISM_pParameter;
    private static final Method method_CK_MECHANISM_setParameter;
    private static final Constructor<?> constructor_CK_MECHANISM_CCM;
    private static final Constructor<?> constructor_CK_MECHANISM_GCM;
    private static final Constructor<?> constructor_CK_MECHANISM_TLS12KeyMat;
    private static final Constructor<?> constructor_CK_MECHANISM_TLS12MasterKeyDerive;
    private static final Constructor<?> constructor_CK_MECHANISM_TLSMac;
    private final Module module;
    private final PKCS11 pkcs11Module;
    private long sessionHandle;
    private VendorCodeConverter vendorCodeConverter;
    private final Token token;

    private static Constructor<?> getConstructofOfCK_MECHANISM(String paramsClassName) {
        Class<?> paramsClass;
        try {
            paramsClass = Class.forName(paramsClassName);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return Util.getConstructor(CK_MECHANISM.class, Long.TYPE, paramsClass);
    }

    protected Session(Token token, long sessionHandle) {
        this.token = Util.requireNonNull("token", token);
        this.module = token.getSlot().getModule();
        this.vendorCodeConverter = this.module.getVendorCodeConverter();
        this.pkcs11Module = this.module.getPKCS11Module();
        this.sessionHandle = sessionHandle;
    }

    public void closeSession() throws TokenException {
        try {
            this.pkcs11Module.C_CloseSession(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Session)) {
            return false;
        }
        Session other = (Session)otherObject;
        if (this.sessionHandle != other.sessionHandle) {
            return false;
        }
        return this.token.equals(other.token);
    }

    public int hashCode() {
        return (int)this.sessionHandle;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public SessionInfo getSessionInfo() throws TokenException {
        CK_SESSION_INFO ckSessionInfo;
        try {
            ckSessionInfo = this.pkcs11Module.C_GetSessionInfo(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return new SessionInfo(ckSessionInfo);
    }

    public Module getModule() {
        return this.module;
    }

    public Token getToken() {
        return this.token;
    }

    public byte[] getOperationState() throws TokenException {
        try {
            return this.pkcs11Module.C_GetOperationState(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void setOperationState(byte[] operationState, Key encryptionKey, Key authenticationKey) throws TokenException {
        try {
            this.pkcs11Module.C_SetOperationState(this.sessionHandle, operationState, encryptionKey.getObjectHandle(), authenticationKey.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void setSessionHandle(long sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public void login(boolean userType, char[] pin) throws TokenException {
        long tmpUserType = !userType ? 0L : 1L;
        try {
            this.pkcs11Module.C_Login(this.sessionHandle, tmpUserType, pin);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void login(long userType, char[] pin) throws TokenException {
        try {
            this.pkcs11Module.C_Login(this.sessionHandle, userType, pin);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void logout() throws TokenException {
        try {
            this.pkcs11Module.C_Logout(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object createObject(PKCS11Object templateObject) throws TokenException {
        long objectHandle;
        CK_ATTRIBUTE[] ckAttributes = this.getSetAttributes(templateObject);
        try {
            objectHandle = this.pkcs11Module.C_CreateObject(this.sessionHandle, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return PKCS11Object.getInstance(this, objectHandle);
    }

    public PKCS11Object copyObject(PKCS11Object sourceObject, PKCS11Object templateObject) throws TokenException {
        long newObjectHandle;
        long sourceObjectHandle = sourceObject.getObjectHandle();
        CK_ATTRIBUTE[] ckAttributes = this.getSetAttributes(templateObject);
        try {
            newObjectHandle = this.pkcs11Module.C_CopyObject(this.sessionHandle, sourceObjectHandle, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return PKCS11Object.getInstance(this, newObjectHandle);
    }

    public void setAttributeValues(PKCS11Object objectToUpdate, PKCS11Object templateObject) throws TokenException {
        long objectToUpdateHandle = objectToUpdate.getObjectHandle();
        CK_ATTRIBUTE[] ckAttributesTemplates = this.getSetAttributes(templateObject);
        try {
            this.pkcs11Module.C_SetAttributeValue(this.sessionHandle, objectToUpdateHandle, ckAttributesTemplates);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object getAttributeValues(PKCS11Object objectToRead) throws TokenException {
        long objectHandle = objectToRead.getObjectHandle();
        return PKCS11Object.getInstance(this, objectHandle);
    }

    public void destroyObject(PKCS11Object object) throws TokenException {
        long objectHandle = object.getObjectHandle();
        try {
            this.pkcs11Module.C_DestroyObject(this.sessionHandle, objectHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void findObjectsInit(PKCS11Object templateObject) throws TokenException {
        CK_ATTRIBUTE[] ckAttributes = this.getSetAttributes(templateObject);
        try {
            this.pkcs11Module.C_FindObjectsInit(this.sessionHandle, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object[] findObjects(int maxObjectCount) throws TokenException {
        long[] objectHandles;
        Vector<PKCS11Object> foundObjects = new Vector<PKCS11Object>();
        try {
            objectHandles = this.pkcs11Module.C_FindObjects(this.sessionHandle, maxObjectCount);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        try {
            for (long objectHandle : objectHandles) {
                PKCS11Object object = PKCS11Object.getInstance(this, objectHandle);
                foundObjects.addElement(object);
            }
            Object[] objectArray = new PKCS11Object[foundObjects.size()];
            foundObjects.copyInto(objectArray);
            return objectArray;
        }
        catch (TokenException e) {
            throw new TokenException(e);
        }
    }

    public void findObjectsFinal() throws TokenException {
        try {
            this.pkcs11Module.C_FindObjectsFinal(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void encryptInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_EncryptInit(this.sessionHandle, this.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int encrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            if (encrypt0 != null) {
                return (Integer)encrypt0.invoke((Object)this.pkcs11Module, this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
            }
            if (encrypt1 != null) {
                return (Integer)encrypt1.invoke((Object)this.pkcs11Module, this.sessionHandle, 0, in, inOfs, inLen, 0, out, outOfs, outLen);
            }
            throw new IllegalStateException("could not find C_ENCRYPT method");
        }
        catch (IllegalAccessException ex) {
            throw new TokenException("", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof sun.security.pkcs11.wrapper.PKCS11Exception) {
                throw new PKCS11Exception(((sun.security.pkcs11.wrapper.PKCS11Exception)cause).getErrorCode());
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new TokenException("Error " + ex.getMessage(), ex);
        }
    }

    public int encryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_EncryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int encryptFinal(byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_EncryptFinal(this.sessionHandle, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void decryptInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_DecryptInit(this.sessionHandle, this.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int decrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            if (decrypt0 != null) {
                return (Integer)decrypt0.invoke((Object)this.pkcs11Module, this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
            }
            if (decrypt1 != null) {
                return (Integer)decrypt1.invoke((Object)this.pkcs11Module, this.sessionHandle, 0, in, inOfs, inLen, 0, out, outOfs, outLen);
            }
            throw new IllegalStateException("could not find C_DECRYPT method");
        }
        catch (IllegalAccessException ex) {
            throw new TokenException("", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof sun.security.pkcs11.wrapper.PKCS11Exception) {
                throw new PKCS11Exception(((sun.security.pkcs11.wrapper.PKCS11Exception)cause).getErrorCode());
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new TokenException("Error " + ex.getMessage(), ex);
        }
    }

    public int decryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_DecryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int decryptFinal(byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_DecryptFinal(this.sessionHandle, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void digestInit(Mechanism mechanism) throws TokenException {
        try {
            this.pkcs11Module.C_DigestInit(this.sessionHandle, this.toCkMechanism(mechanism));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int digest(byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws TokenException {
        this.digestUpdate(in, inOfs, inLen);
        return this.digestFinal(digest, digestOfs, digestLen);
    }

    public int digestSingle(Mechanism mechanism, byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("digest", digest);
        try {
            return this.pkcs11Module.C_DigestSingle(this.sessionHandle, this.toCkMechanism(mechanism), in, inOfs, inLen, digest, digestOfs, digestLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void digestUpdate(byte[] part, int partOfs, int partLen) throws TokenException {
        Util.requireNonNull("part", part);
        try {
            this.pkcs11Module.C_DigestUpdate(this.sessionHandle, 0L, part, partOfs, partLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void digestKey(SecretKey key) throws TokenException {
        try {
            this.pkcs11Module.C_DigestKey(this.sessionHandle, key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int digestFinal(byte[] digest, int digestOfs, int digestLen) throws TokenException {
        Util.requireNonNull("digest", digest);
        try {
            return this.pkcs11Module.C_DigestFinal(this.sessionHandle, digest, digestOfs, digestLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void signInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_SignInit(this.sessionHandle, this.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public byte[] sign(byte[] data) throws TokenException {
        Util.requireNonNull("data", data);
        try {
            return this.pkcs11Module.C_Sign(this.sessionHandle, data);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void signUpdate(byte[] in, int inOfs, int inLen) throws TokenException {
        Util.requireNonNull("in", in);
        try {
            this.pkcs11Module.C_SignUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public byte[] signFinal(int expectedLen) throws TokenException {
        try {
            return this.pkcs11Module.C_SignFinal(this.sessionHandle, expectedLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void signRecoverInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_SignRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int signRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_SignRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_VerifyInit(this.sessionHandle, this.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verify(byte[] data, byte[] signature) throws TokenException {
        Util.requireNonNull("signature", signature);
        try {
            this.pkcs11Module.C_Verify(this.sessionHandle, data, signature);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyUpdate(byte[] in, int inOfs, int inLen) throws TokenException {
        Util.requireNonNull("in", in);
        try {
            this.pkcs11Module.C_VerifyUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyFinal(byte[] signature) throws TokenException {
        Util.requireNonNull("signature", signature);
        try {
            this.pkcs11Module.C_VerifyFinal(this.sessionHandle, signature);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyRecoverInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_VerifyRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int verifyRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_VerifyRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object generateKey(Mechanism mechanism, PKCS11Object template) throws TokenException {
        long objectHandle;
        CK_ATTRIBUTE[] ckAttributes = this.getSetAttributes(template);
        try {
            objectHandle = this.pkcs11Module.C_GenerateKey(this.sessionHandle, this.toCkMechanism(mechanism), ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return PKCS11Object.getInstance(this, objectHandle);
    }

    public KeyPair generateKeyPair(Mechanism mechanism, PKCS11Object publicKeyTemplate, PKCS11Object privateKeyTemplate) throws TokenException {
        long[] objectHandles;
        CK_ATTRIBUTE[] ckPublicKeyAttributes = this.getSetAttributes(publicKeyTemplate);
        CK_ATTRIBUTE[] ckPrivateKeyAttributes = this.getSetAttributes(privateKeyTemplate);
        try {
            objectHandles = this.pkcs11Module.C_GenerateKeyPair(this.sessionHandle, this.toCkMechanism(mechanism), ckPublicKeyAttributes, ckPrivateKeyAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        PublicKey publicKey = (PublicKey)PKCS11Object.getInstance(this, objectHandles[0]);
        PrivateKey privateKey = (PrivateKey)PKCS11Object.getInstance(this, objectHandles[1]);
        return new KeyPair(publicKey, privateKey);
    }

    public byte[] wrapKey(Mechanism mechanism, Key wrappingKey, Key key) throws TokenException {
        try {
            return this.pkcs11Module.C_WrapKey(this.sessionHandle, this.toCkMechanism(mechanism), wrappingKey.getObjectHandle(), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public Key unwrapKey(Mechanism mechanism, Key unwrappingKey, byte[] wrappedKey, PKCS11Object keyTemplate) throws TokenException {
        long objectHandle;
        Util.requireNonNull("wrappedKey", wrappedKey);
        CK_ATTRIBUTE[] ckAttributes = this.getSetAttributes(keyTemplate);
        try {
            objectHandle = this.pkcs11Module.C_UnwrapKey(this.sessionHandle, this.toCkMechanism(mechanism), unwrappingKey.getObjectHandle(), wrappedKey, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return (Key)PKCS11Object.getInstance(this, objectHandle);
    }

    public Key deriveKey(Mechanism mechanism, Key baseKey, Key template) throws TokenException {
        long objectHandle;
        CK_MECHANISM ckMechanism = this.toCkMechanism(mechanism);
        Parameters params = mechanism.getParameters();
        CK_ATTRIBUTE[] ckAttributes = this.getSetAttributes(template);
        try {
            objectHandle = this.pkcs11Module.C_DeriveKey(this.sessionHandle, ckMechanism, baseKey.getObjectHandle(), ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        if ((ckMechanism.mechanism == 881L || ckMechanism.mechanism == 885L) && params instanceof SSL3MasterKeyDeriveParameters) {
            VersionParameters version = ((SSL3MasterKeyDeriveParameters)params).getVersion();
            version.setPKCS11ParamsObject(((CK_SSL3_MASTER_KEY_DERIVE_PARAMS)ckMechanism.pParameter).pVersion);
            return (Key)PKCS11Object.getInstance(this, objectHandle);
        }
        if (ckMechanism.mechanism == 992L && params instanceof TLS12MasterKeyDeriveParameters) {
            VersionParameters version = ((TLS12MasterKeyDeriveParameters)params).getVersion();
            CK_VERSION ckVersion = TLS12MasterKeyDeriveParameters.getPVersion(ckMechanism.pParameter);
            version.setPKCS11ParamsObject(ckVersion);
            return (Key)PKCS11Object.getInstance(this, objectHandle);
        }
        if ((ckMechanism.mechanism == 882L || ckMechanism.mechanism == 886L) && params instanceof SSL3KeyMaterialParameters) {
            ((SSL3KeyMaterialParameters)params).getReturnedKeyMaterial().setPKCS11ParamsObject(((CK_SSL3_KEY_MAT_PARAMS)ckMechanism.pParameter).pReturnedKeyMaterial, this);
            return null;
        }
        if (ckMechanism.mechanism == 993L && params instanceof TLS12KeyMaterialParameters) {
            CK_SSL3_KEY_MAT_OUT pReturnedMaterial = TLS12KeyMaterialParameters.getPReturnedKeyMaterial(ckMechanism.pParameter);
            ((TLS12KeyMaterialParameters)params).getReturnedKeyMaterial().setPKCS11ParamsObject(pReturnedMaterial, this);
            return null;
        }
        return (Key)PKCS11Object.getInstance(this, objectHandle);
    }

    public void seedRandom(byte[] seed) throws TokenException {
        try {
            this.pkcs11Module.C_SeedRandom(this.sessionHandle, seed);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws TokenException {
        byte[] randomBytesBuffer = new byte[numberOfBytesToGenerate];
        try {
            this.pkcs11Module.C_GenerateRandom(this.sessionHandle, randomBytesBuffer);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return randomBytesBuffer;
    }

    public String toString() {
        return Util.concatObjectsCap(100, "Session Handle: 0x", Long.toHexString(this.sessionHandle), "\nToken: ", this.token);
    }

    private CK_MECHANISM toCkMechanism(Mechanism mechanism) {
        Parameters params;
        long code = mechanism.getMechanismCode();
        if ((code & 0x80000000L) != 0L && this.vendorCodeConverter != null) {
            code = this.vendorCodeConverter.genericToVendorCKM(code);
        }
        if ((params = mechanism.getParameters()) == null) {
            return new CK_MECHANISM(code);
        }
        if (params instanceof AesCtrParameters) {
            return new CK_MECHANISM(code, ((AesCtrParameters)params).getPKCS11ParamsObject());
        }
        if (params instanceof DHPkcsDeriveParameters) {
            return new CK_MECHANISM(code, ((DHPkcsDeriveParameters)params).getPKCS11ParamsObject());
        }
        if (params instanceof EcDH1KeyDerivationParameters) {
            return new CK_MECHANISM(code, ((EcDH1KeyDerivationParameters)params).getPKCS11ParamsObject());
        }
        if (!(params instanceof EcDH2KeyDerivationParameters)) {
            if (params instanceof ExtractParameters) {
                return new CK_MECHANISM(code, ((ExtractParameters)params).getPKCS11ParamsObject());
            }
            if (params instanceof InitializationVectorParameters) {
                return new CK_MECHANISM(code, ((InitializationVectorParameters)params).getPKCS11ParamsObject());
            }
            if (params instanceof MacGeneralParameters) {
                return new CK_MECHANISM(code, ((MacGeneralParameters)params).getPKCS11ParamsObject());
            }
            if (params instanceof ObjectHandleParameters) {
                return new CK_MECHANISM(code, ((ObjectHandleParameters)params).getPKCS11ParamsObject());
            }
            if (params instanceof OpaqueParameters) {
                return new CK_MECHANISM(code, ((OpaqueParameters)params).getPKCS11ParamsObject());
            }
            if (!(params instanceof PBEParameters || params instanceof PKCS5PBKD2Parameters || params instanceof RSAPkcsOaepParameters)) {
                if (params instanceof RSAPkcsPssParameters) {
                    CK_MECHANISM mech;
                    block26: {
                        mech = new CK_MECHANISM(code);
                        CK_RSA_PKCS_PSS_PARAMS pParams = ((RSAPkcsPssParameters)params).getPKCS11ParamsObject();
                        try {
                            if (field_CK_MECHANISM_pParameter != null) {
                                field_CK_MECHANISM_pParameter.set(mech, pParams);
                                break block26;
                            }
                            if (method_CK_MECHANISM_setParameter != null) {
                                method_CK_MECHANISM_setParameter.invoke((Object)mech, pParams);
                                break block26;
                            }
                            throw new IllegalStateException("could not construct CK_MECHANISM for RSAPkcsPssParams");
                        }
                        catch (IllegalAccessException | InvocationTargetException ex) {
                            throw new IllegalStateException("could not construct CK_MECHANISM for RSAPkcsPssParams", ex);
                        }
                    }
                    return mech;
                }
                if (params instanceof SSL3KeyMaterialParameters) {
                    return new CK_MECHANISM(code, ((SSL3KeyMaterialParameters)params).getPKCS11ParamsObject());
                }
                if (params instanceof SSL3MasterKeyDeriveParameters) {
                    return new CK_MECHANISM(code, ((SSL3MasterKeyDeriveParameters)params).getPKCS11ParamsObject());
                }
                if (!(params instanceof SSL3RandomDataParameters)) {
                    if (params instanceof TLSPRFParameters) {
                        return new CK_MECHANISM(code, ((TLSPRFParameters)params).getPKCS11ParamsObject());
                    }
                    if (params instanceof VersionParameters) {
                        return new CK_MECHANISM(code, ((VersionParameters)params).getPKCS11ParamsObject());
                    }
                    if (!(params instanceof X942DH1KeyDerivationParameters) && !(params instanceof X942DH2KeyDerivationParameters)) {
                        Constructor<Object> constructor = params instanceof CCMParameters ? constructor_CK_MECHANISM_CCM : (params instanceof GCMParameters ? constructor_CK_MECHANISM_GCM : (params instanceof TLS12KeyMaterialParameters ? constructor_CK_MECHANISM_TLS12KeyMat : (params instanceof TLS12MasterKeyDeriveParameters ? constructor_CK_MECHANISM_TLS12MasterKeyDerive : (params instanceof TLSMacParameters ? constructor_CK_MECHANISM_TLSMac : null))));
                        if (constructor == null) {
                            throw new IllegalArgumentException("could not find constructor");
                        }
                        try {
                            return (CK_MECHANISM)constructor.newInstance(code, params.getPKCS11ParamsObject());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                            throw new IllegalArgumentException("could not construct CK_MECHANISM", ex);
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unsupported Parameters " + params.getClass().getName());
    }

    private CK_ATTRIBUTE[] getSetAttributes(PKCS11Object object) throws PKCS11Exception {
        return PKCS11Object.getSetAttributes(object, this.module.getVendorCodeConverter());
    }

    static {
        Class clazz = PKCS11.class;
        decrypt0 = Util.getMethod(clazz, "C_Decrypt", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        encrypt0 = Util.getMethod(clazz, "C_Encrypt", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        decrypt1 = decrypt0 == null ? Util.getMethod(clazz, "C_Decrypt", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE) : null;
        encrypt1 = encrypt0 == null ? Util.getMethod(clazz, "C_Encrypt", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE) : null;
        clazz = CK_MECHANISM.class;
        field_CK_MECHANISM_pParameter = Util.getField(clazz, "pParameter");
        method_CK_MECHANISM_setParameter = Util.getMethod(clazz, "setParameter", CK_RSA_PKCS_PSS_PARAMS.class);
        constructor_CK_MECHANISM_CCM = Session.getConstructofOfCK_MECHANISM("sun.security.pkcs11.wrapper.CK_CCM_PARAMS");
        constructor_CK_MECHANISM_GCM = Session.getConstructofOfCK_MECHANISM("sun.security.pkcs11.wrapper.CK_GCM_PARAMS");
        constructor_CK_MECHANISM_TLS12KeyMat = Session.getConstructofOfCK_MECHANISM("sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS");
        constructor_CK_MECHANISM_TLS12MasterKeyDerive = Session.getConstructofOfCK_MECHANISM("sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS");
        constructor_CK_MECHANISM_TLSMac = Session.getConstructofOfCK_MECHANISM("sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS");
    }

    public static interface UserType {
        public static final boolean SO = false;
        public static final boolean USER = true;
    }
}

