/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Version;
import java.util.Date;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;

public class TokenInfo {
    public static final long EFFECTIVELY_INFINITE = 0L;
    public static final long UNAVAILABLE_INFORMATION = 0xFFFFFFFFL;
    private final String label;
    private final String manufacturerID;
    private final String model;
    private final String serialNumber;
    private final long maxSessionCount;
    private final long sessionCount;
    private final long maxRwSessionCount;
    private final long rwSessionCount;
    private final long maxPinLen;
    private final long minPinLen;
    private final long totalPublicMemory;
    private final long freePublicMemory;
    private final long totalPrivateMemory;
    private final long freePrivateMemory;
    private final Version hardwareVersion;
    private final Version firmwareVersion;
    private final Date time;
    private final long flags;

    protected TokenInfo(CK_TOKEN_INFO ckTokenInfo) {
        Util.requireNonNull("ckTokenInfo", ckTokenInfo);
        this.label = new String(ckTokenInfo.label);
        this.manufacturerID = new String(ckTokenInfo.manufacturerID);
        this.model = new String(ckTokenInfo.model);
        this.serialNumber = new String(ckTokenInfo.serialNumber);
        this.maxSessionCount = ckTokenInfo.ulMaxSessionCount;
        this.sessionCount = ckTokenInfo.ulSessionCount;
        this.maxRwSessionCount = ckTokenInfo.ulMaxRwSessionCount;
        this.rwSessionCount = ckTokenInfo.ulRwSessionCount;
        this.maxPinLen = ckTokenInfo.ulMaxPinLen;
        this.minPinLen = ckTokenInfo.ulMinPinLen;
        this.totalPublicMemory = ckTokenInfo.ulTotalPublicMemory;
        this.freePublicMemory = ckTokenInfo.ulFreePublicMemory;
        this.totalPrivateMemory = ckTokenInfo.ulTotalPrivateMemory;
        this.freePrivateMemory = ckTokenInfo.ulFreePrivateMemory;
        this.hardwareVersion = new Version(ckTokenInfo.hardwareVersion);
        this.firmwareVersion = new Version(ckTokenInfo.firmwareVersion);
        this.time = Util.parseTime(ckTokenInfo.utcTime);
        this.flags = ckTokenInfo.flags;
    }

    public String getLabel() {
        return this.label;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public long getMaxSessionCount() {
        return this.maxSessionCount;
    }

    public long getSessionCount() {
        return this.sessionCount;
    }

    public long getMaxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public long getRwSessionCount() {
        return this.rwSessionCount;
    }

    public long getMaxPinLen() {
        return this.maxPinLen;
    }

    public long getMinPinLen() {
        return this.minPinLen;
    }

    public long getTotalPublicMemory() {
        return this.totalPublicMemory;
    }

    public long getFreePublicMemory() {
        return this.freePublicMemory;
    }

    public long getTotalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public long getFreePrivateMemory() {
        return this.freePrivateMemory;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public Date getTime() {
        return this.time;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean isRNG() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isWriteProtected() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isLoginRequired() {
        return (this.flags & 4L) != 0L;
    }

    public boolean isUserPinInitialized() {
        return (this.flags & 8L) != 0L;
    }

    public boolean isRestoreKeyNotNeeded() {
        return (this.flags & 0x20L) != 0L;
    }

    public boolean isClockOnToken() {
        return (this.flags & 0x40L) != 0L;
    }

    public boolean isProtectedAuthenticationPath() {
        return (this.flags & 0x100L) != 0L;
    }

    public boolean isDualCryptoOperations() {
        return (this.flags & 0x200L) != 0L;
    }

    public boolean isTokenInitialized() {
        return (this.flags & 0x400L) != 0L;
    }

    public boolean isSecondaryAuthentication() {
        return (this.flags & 0x800L) != 0L;
    }

    public boolean isUserPinCountLow() {
        return (this.flags & 0x10000L) != 0L;
    }

    public boolean isUserPinFinalTry() {
        return (this.flags & 0x20000L) != 0L;
    }

    public boolean isUserPinLocked() {
        return (this.flags & 0x40000L) != 0L;
    }

    public boolean isUserPinToBeChanged() {
        return (this.flags & 0x80000L) != 0L;
    }

    public boolean isSoPinCountLow() {
        return (this.flags & 0x100000L) != 0L;
    }

    public boolean isSoPinFinalTry() {
        return (this.flags & 0x200000L) != 0L;
    }

    public boolean isSoPinLocked() {
        return (this.flags & 0x400000L) != 0L;
    }

    public boolean isSoPinToBeChanged() {
        return (this.flags & 0x800000L) != 0L;
    }

    public String toString() {
        return Util.concatObjectsCap(1000, "\nManufacturer ID: ", this.manufacturerID, "\nModel: ", this.model, "\nSerial Number: ", this.serialNumber, "\nFlags: 0x", Util.toFullHex(this.flags), "\nRandom Number Generator: ", this.isRNG(), "\nWrite protected: ", this.isWriteProtected(), "\nLogin required: ", this.isLoginRequired(), "\nUser PIN initialized: ", this.isUserPinInitialized(), "\nRestore Key not needed: ", this.isRestoreKeyNotNeeded(), "\nClock on Token: ", this.isClockOnToken(), "\nProtected Authentication Path: ", this.isProtectedAuthenticationPath(), "\nDual Crypto Operations: ", this.isDualCryptoOperations(), "\nToken initialized: ", this.isTokenInitialized(), "\nSecondary Authentication: ", this.isSecondaryAuthentication(), "\nUser PIN-Count low: ", this.isUserPinCountLow(), "\nUser PIN final Try: ", this.isUserPinFinalTry(), "\nUser PIN locked: ", this.isUserPinLocked(), "\nUser PIN to be changed: ", this.isUserPinToBeChanged(), "\nSecurity Officer PIN-Count low: ", this.isSoPinCountLow(), "\nSecurity Officer PIN final Try: ", this.isSoPinFinalTry(), "\nSecurity Officer PIN locked: ", this.isSoPinLocked(), "\nSecurity Officer PIN to be changed: ", this.isSoPinToBeChanged(), "\nMaximum Session Count: ", TokenInfo.maxCountToString(this.maxSessionCount), "\nSession Count: ", TokenInfo.countToString(this.sessionCount), "\nMaximum Read/Write Session Count: ", TokenInfo.maxCountToString(this.maxRwSessionCount), "\nRead/Write Session Count: ", TokenInfo.countToString(this.rwSessionCount), "\nMaximum PIN Length: ", this.maxPinLen, "\nMinimum PIN Length: ", this.minPinLen, "\nTotal Public Memory: ", TokenInfo.countToString(this.totalPrivateMemory), "\nFree Public Memory: ", TokenInfo.countToString(this.freePublicMemory), "\nTotal Private Memory: ", TokenInfo.countToString(this.totalPrivateMemory), "\nFree Private Memory: ", TokenInfo.countToString(this.freePublicMemory), "\nHardware Version: ", this.hardwareVersion, "\nFirmware Version: ", this.firmwareVersion, "\nTime: ", this.time);
    }

    private static String maxCountToString(long count) {
        if (count == 0xFFFFFFFFL) {
            return "<Information unavailable>";
        }
        return count == 0L ? "<effectively infinite>" : Long.toString(count);
    }

    private static String countToString(long count) {
        if (count == 0xFFFFFFFFL) {
            return "<Information unavailable>";
        }
        return Long.toString(count);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof TokenInfo)) {
            return false;
        }
        TokenInfo other = (TokenInfo)otherObject;
        return this.label.equals(other.label) && this.manufacturerID.equals(other.manufacturerID) && this.model.equals(other.model) && this.serialNumber.equals(other.serialNumber) && this.maxSessionCount == other.maxSessionCount && this.sessionCount == other.sessionCount && this.maxRwSessionCount == other.maxRwSessionCount && this.rwSessionCount == other.rwSessionCount && this.maxPinLen == other.maxPinLen && this.minPinLen == other.minPinLen && this.totalPublicMemory == other.totalPublicMemory && this.freePublicMemory == other.freePublicMemory && this.totalPrivateMemory == other.totalPrivateMemory && this.freePrivateMemory == other.freePrivateMemory && this.hardwareVersion.equals(other.hardwareVersion) && this.firmwareVersion.equals(other.firmwareVersion) && this.time.equals(other.time) && this.flags == other.flags;
    }

    public int hashCode() {
        return this.label.hashCode() ^ this.manufacturerID.hashCode() ^ this.model.hashCode() ^ this.serialNumber.hashCode();
    }
}

