/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.parameters.CCMParameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_DATE;

public class Util {
    public static <T> T requireNonNull(String paramName, T param) {
        if (param == null) {
            throw new NullPointerException("Argument \"" + paramName + "\" must not be null.");
        }
        return param;
    }

    public static Date parseTime(char[] timeChars) {
        Date time = null;
        if (timeChars != null && timeChars.length > 2) {
            String timeString = new String(timeChars, 0, timeChars.length - 2);
            try {
                SimpleDateFormat utc = new SimpleDateFormat("yyyyMMddhhmmss");
                utc.setTimeZone(TimeZone.getTimeZone("UTC"));
                time = utc.parse(timeString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return time;
    }

    public static Date convertToDate(CK_DATE ckDate) {
        Date date = null;
        if (ckDate != null) {
            int year = Integer.parseInt(new String(ckDate.year));
            int month = Integer.parseInt(new String(ckDate.month));
            int day = Integer.parseInt(new String(ckDate.day));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(year, 0 + (month - 1), day);
            date = calendar.getTime();
        }
        return date;
    }

    public static CK_DATE convertToCkDate(Date date) {
        CK_DATE ckDate = null;
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            ckDate = new CK_DATE(Util.toCharArray(year, 4), Util.toCharArray(month, 2), Util.toCharArray(day, 2));
        }
        return ckDate;
    }

    public static char[] toCharArray(int number, int exactArrayLength) {
        char[] charArray = null;
        String numberString = Integer.toString(number);
        char[] numberChars = numberString.toCharArray();
        if (numberChars.length > exactArrayLength) {
            charArray = new char[exactArrayLength];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = numberChars[i];
            }
        } else if (numberChars.length < exactArrayLength) {
            charArray = new char[exactArrayLength];
            int offset = exactArrayLength - numberChars.length;
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = i < offset ? 48 : numberChars[i - offset];
            }
        } else {
            charArray = numberChars;
        }
        return charArray;
    }

    public static char[] toPaddedCharArray(String string, int exactArrayLength, char paddingChar) {
        char[] charArray = null;
        if (string != null) {
            int stringLength = string.length();
            charArray = new char[exactArrayLength];
            string.getChars(0, Math.min(stringLength, exactArrayLength), charArray, 0);
            for (int i = stringLength; i < charArray.length; ++i) {
                charArray[i] = paddingChar;
            }
        }
        return charArray;
    }

    public static byte[] unsignedBigIntergerToByteArray(BigInteger bigInteger) {
        byte[] unsignedIntegerBytes;
        if (bigInteger == null) {
            return null;
        }
        byte[] integerBytes = bigInteger.toByteArray();
        if (integerBytes.length > 0 && integerBytes[0] == 0) {
            unsignedIntegerBytes = new byte[integerBytes.length - 1];
            for (int i = 0; i < unsignedIntegerBytes.length; ++i) {
                unsignedIntegerBytes[i] = integerBytes[i + 1];
            }
        } else {
            unsignedIntegerBytes = integerBytes;
        }
        return unsignedIntegerBytes;
    }

    public static CK_ATTRIBUTE[] convertAttributesVectorToArray(Vector<CK_ATTRIBUTE> attributes) {
        if (attributes == null) {
            return null;
        }
        int numberOfAttributes = attributes.size();
        CK_ATTRIBUTE[] attributeArray = new CK_ATTRIBUTE[numberOfAttributes];
        for (int i = 0; i < numberOfAttributes; ++i) {
            attributeArray[i] = attributes.elementAt(i);
        }
        return attributeArray;
    }

    public static boolean objEquals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    static String toFullHex(long value) {
        return Functions.toFullHex(value);
    }

    public static String toHex(byte[] value) {
        if (value == null) {
            return null;
        }
        return Functions.toHexString(value);
    }

    public static String concat(String s1, String ... strs) {
        int len = s1 == null ? 4 : s1.length();
        for (String str : strs) {
            len += str == null ? 4 : str.length();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(s1);
        for (String str : strs) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String concatObjects(Object o1, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        sb.append(o1);
        for (Object obj : objs) {
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String concatObjectsCap(int cap, Object o1, Object ... objs) {
        StringBuilder sb = new StringBuilder(cap);
        sb.append(o1);
        for (Object obj : objs) {
            sb.append(obj);
        }
        return sb.toString();
    }

    public static int hashCode(byte[] array) {
        int hash = 0;
        if (array != null) {
            for (int i = 0; i < 4 && i < array.length; ++i) {
                hash ^= (0xFF & array[i]) << (i % 4 << 3);
            }
        }
        return hash;
    }

    public static int hashCode(char[] array) {
        int hash = 0;
        if (array != null) {
            for (int i = 0; i < 4 && i < array.length; ++i) {
                hash ^= 0xFFFFFFFF & array[i];
            }
        }
        return hash;
    }

    public static int hashCode(long[] array) {
        int hash = 0;
        if (array != null) {
            for (int i = 0; i < 4 && i < array.length; ++i) {
                hash = (int)((long)hash ^ 0xFFFFFFFFFFFFFFFFL & array[i] >> 4);
                hash = (int)((long)hash ^ 0xFFFFFFFFFFFFFFFFL & array[i]);
            }
        }
        return hash;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getField(fieldName);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static Constructor<?> getConstructor(String className, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className, false, CCMParameters.class.getClassLoader());
            return Util.getConstructor(clazz, parameterTypes);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Throwable th) {
            return null;
        }
    }
}

