/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CertificateTypeAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.WTLSCertificate;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Certificate
extends Storage {
    protected static VendorDefinedCertificateBuilder vendorCertificateBuilder;
    protected CertificateTypeAttribute certificateType;
    protected BooleanAttribute trusted;
    protected LongAttribute certificateCategory;
    protected ByteArrayAttribute checkValue;
    protected DateAttribute startDate;
    protected DateAttribute endDate;

    public Certificate() {
        this.objectClass.setLongValue(1L);
    }

    protected Certificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(1L);
    }

    public static String getCertificateTypeName(Long certificateType) {
        Util.requireNonNull("certificateType", certificateType);
        String certificateTypeName = certificateType.equals(0L) ? "X.509 Public Key" : (certificateType.equals(1L) ? "X.509 Attribute" : ((certificateType & 0x80000000L) != 0L ? "Vendor Defined" : "<unknown>"));
        return certificateTypeName;
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        CertificateTypeAttribute certificateTypeAttribute = new CertificateTypeAttribute();
        Certificate.getAttributeValue(session, objectHandle, certificateTypeAttribute);
        Long certificateType = certificateTypeAttribute.getLongValue();
        PKCS11Object newObject = certificateTypeAttribute.isPresent() && certificateType != null ? (certificateType.equals(0L) ? X509PublicKeyCertificate.getInstance(session, objectHandle) : (certificateType.equals(1L) ? X509AttributeCertificate.getInstance(session, objectHandle) : (certificateType.equals(2L) ? WTLSCertificate.getInstance(session, objectHandle) : ((certificateType & 0x80000000L) != 0L ? Certificate.getUnknownCertificate(session, objectHandle) : Certificate.getUnknownCertificate(session, objectHandle))))) : Certificate.getUnknownCertificate(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownCertificate(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (vendorCertificateBuilder != null) {
            try {
                newObject = vendorCertificateBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new Certificate(session, objectHandle);
            }
        } else {
            newObject = new Certificate(session, objectHandle);
        }
        return newObject;
    }

    public static void setVendorDefinedCertificateBuilder(VendorDefinedCertificateBuilder builder) {
        vendorCertificateBuilder = builder;
    }

    public static VendorDefinedCertificateBuilder getVendorDefinedCertificateBuilder() {
        return vendorCertificateBuilder;
    }

    protected static void putAttributesInTable(Certificate object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(128L, object.certificateType);
        object.attributeTable.put(134L, object.trusted);
        object.attributeTable.put(135L, object.certificateCategory);
        object.attributeTable.put(144L, object.checkValue);
        object.attributeTable.put(272L, object.startDate);
        object.attributeTable.put(273L, object.endDate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.certificateType = new CertificateTypeAttribute();
        this.trusted = new BooleanAttribute((Long)134L);
        this.certificateCategory = new LongAttribute((Long)135L);
        this.checkValue = new ByteArrayAttribute((Long)144L);
        this.startDate = new DateAttribute(272L);
        this.endDate = new DateAttribute(273L);
        Certificate.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)otherObject;
        return super.equals(other) && this.certificateType.equals(other.certificateType) && this.trusted.equals(other.trusted) && this.certificateCategory.equals(other.certificateCategory) && this.checkValue.equals(other.checkValue) && this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate);
    }

    public LongAttribute getCertificateType() {
        return this.certificateType;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted;
    }

    public LongAttribute getCertificateCategory() {
        return this.certificateCategory;
    }

    public ByteArrayAttribute getCheckValue() {
        return this.checkValue;
    }

    public DateAttribute getStartDate() {
        return this.startDate;
    }

    public DateAttribute getEndDate() {
        return this.endDate;
    }

    @Override
    public int hashCode() {
        return this.certificateType.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.trusted, this.certificateCategory, this.checkValue, this.startDate, this.endDate});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\nCertificate Type: ", this.certificateType != null ? this.certificateType : "<unavailable>", "\nTrusted: ", this.trusted, "\nCertificate Category: ", this.certificateCategory, "\nCheck Value: ", this.checkValue, "\nStart Date: ", this.startDate, "\nEnd Date: ", this.endDate);
    }

    public static interface VendorDefinedCertificateBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }

    public static interface CertificateType {
        public static final long X_509_PUBLIC_KEY = 0L;
        public static final long X_509_ATTRIBUTE = 1L;
        public static final long WTLS = 2L;
        public static final long VENDOR_DEFINED = 0x80000000L;
    }
}

