/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import java.nio.charset.StandardCharsets;

public class Clock
extends HardwareFeature {
    protected ByteArrayAttribute value;

    public Clock() {
        this.hardwareFeatureType.setLongValue(2L);
    }

    protected Clock(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.hardwareFeatureType.setLongValue(2L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new Clock(session, objectHandle);
    }

    protected static void putAttributesInTable(Clock object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(17L, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value = new ByteArrayAttribute((Long)17L);
        Clock.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Clock)) {
            return false;
        }
        Clock other = (Clock)otherObject;
        return super.equals(other) && this.value.equals(other.value);
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\nValue: ");
        sb.append(new String(this.value.getByteArrayValue(), StandardCharsets.US_ASCII));
        return sb.toString();
    }
}

