/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PublicKey;

public class DHPublicKey
extends PublicKey {
    protected ByteArrayAttribute prime;
    protected ByteArrayAttribute base;
    protected ByteArrayAttribute value;

    public DHPublicKey() {
        this.keyType.setLongValue(2L);
    }

    protected DHPublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(2L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new DHPublicKey(session, objectHandle);
    }

    protected static void putAttributesInTable(DHPublicKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(304L, object.prime);
        object.attributeTable.put(306L, object.base);
        object.attributeTable.put(17L, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute((Long)304L);
        this.base = new ByteArrayAttribute((Long)306L);
        this.value = new ByteArrayAttribute((Long)17L);
        DHPublicKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DHPublicKey)) {
            return false;
        }
        DHPublicKey other = (DHPublicKey)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.base.equals(other.base) && this.value.equals(other.value);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.base, this.value});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Base (hex): ", this.base, "\n  Value (hex): ", this.value);
    }
}

