/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MechanismArrayAttribute;
import iaik.pkcs.pkcs11.objects.MechanismAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.Hashtable;

public class Key
extends Storage {
    protected static Hashtable<Long, String> keyTypeNames;
    protected KeyTypeAttribute keyType;
    protected ByteArrayAttribute id;
    protected DateAttribute startDate;
    protected DateAttribute endDate;
    protected BooleanAttribute derive;
    protected BooleanAttribute local;
    protected MechanismAttribute keyGenMechanism;
    protected MechanismArrayAttribute allowedMechanisms;

    public Key() {
    }

    protected Key(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
    }

    public static String getKeyTypeName(long keyType) {
        String keyTypeName;
        if (keyTypeNames == null) {
            keyTypeNames = new Hashtable(24);
            keyTypeNames.put(0L, "RSA");
            keyTypeNames.put(1L, "DSA");
            keyTypeNames.put(2L, "DH");
            keyTypeNames.put(3L, "EC");
            keyTypeNames.put(64L, "EC_EDWARDS");
            keyTypeNames.put(65L, "EC_MONTGOMERY");
            keyTypeNames.put(4L, "X9_42_DH");
            keyTypeNames.put(5L, "KEA");
            keyTypeNames.put(16L, "GENERIC_SECRET");
            keyTypeNames.put(17L, "RC2");
            keyTypeNames.put(18L, "RC4");
            keyTypeNames.put(19L, "DES");
            keyTypeNames.put(20L, "DES2");
            keyTypeNames.put(21L, "DES3");
            keyTypeNames.put(22L, "CAST");
            keyTypeNames.put(23L, "CAST3");
            keyTypeNames.put(24L, "CAST128");
            keyTypeNames.put(25L, "RC5");
            keyTypeNames.put(26L, "IDEA");
            keyTypeNames.put(27L, "SKIPJACK");
            keyTypeNames.put(28L, "BATON");
            keyTypeNames.put(29L, "JUNIPER");
            keyTypeNames.put(30L, "CDMF");
            keyTypeNames.put(31L, "AES");
            keyTypeNames.put(32L, "BLOWFISH");
            keyTypeNames.put(33L, "TWOFISH");
            keyTypeNames.put(0xFFFFF001L, "SM2");
            keyTypeNames.put(0xFFFFF002L, "SM4");
        }
        if ((keyTypeName = keyTypeNames.get(keyType)) == null) {
            keyTypeName = (keyType & 0x80000000L) != 0L ? "Vendor Defined" : "<unknown>";
        }
        return keyTypeName;
    }

    protected static void putAttributesInTable(Key object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(256L, object.keyType);
        object.attributeTable.put(258L, object.id);
        object.attributeTable.put(272L, object.startDate);
        object.attributeTable.put(273L, object.endDate);
        object.attributeTable.put(268L, object.derive);
        object.attributeTable.put(355L, object.local);
        object.attributeTable.put(358L, object.keyGenMechanism);
        object.attributeTable.put(0x40000600L, object.allowedMechanisms);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.keyType = new KeyTypeAttribute();
        this.id = new ByteArrayAttribute((Long)258L);
        this.startDate = new DateAttribute(272L);
        this.endDate = new DateAttribute(273L);
        this.derive = new BooleanAttribute((Long)268L);
        this.local = new BooleanAttribute((Long)355L);
        this.keyGenMechanism = new MechanismAttribute(358L);
        this.allowedMechanisms = new MechanismArrayAttribute((Long)0x40000600L);
        Key.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Key)) {
            return false;
        }
        Key other = (Key)otherObject;
        return super.equals(other) && this.keyType.equals(other.keyType) && this.id.equals(other.id) && this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate) && this.derive.equals(other.derive) && this.local.equals(other.local) && this.keyGenMechanism.equals(other.keyGenMechanism) && this.allowedMechanisms.equals(other.allowedMechanisms);
    }

    public LongAttribute getKeyType() {
        return this.keyType;
    }

    public ByteArrayAttribute getId() {
        return this.id;
    }

    public DateAttribute getStartDate() {
        return this.startDate;
    }

    public DateAttribute getEndDate() {
        return this.endDate;
    }

    public BooleanAttribute getDerive() {
        return this.derive;
    }

    public BooleanAttribute getLocal() {
        return this.local;
    }

    public MechanismAttribute getKeyGenMechanism() {
        return this.keyGenMechanism;
    }

    public MechanismArrayAttribute getAllowedMechanisms() {
        return this.allowedMechanisms;
    }

    @Override
    public int hashCode() {
        return this.keyType.hashCode() ^ this.id.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.keyType, this.id, this.startDate, this.endDate, this.derive, this.local, this.keyGenMechanism, this.allowedMechanisms});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Key Type: ", this.keyType != null ? this.keyType.toString() : "<unavailable>", "\n  ID: ", this.id, "\n  Start Date: ", this.startDate, "\n  End Date: ", this.endDate, "\n  Derive: ", this.derive, "\n  Local: ", this.local, "\n  Key Generation Mechanism: ", this.keyGenMechanism, "\n  Allowed Mechanisms: ", this.allowedMechanisms);
    }

    public static interface VendorDefinedKeyBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }

    public static interface KeyType {
        public static final long RSA = 0L;
        public static final long DSA = 1L;
        public static final long DH = 2L;
        public static final long EC = 3L;
        public static final long EC_EDWARDS = 64L;
        public static final long EC_MONTGOMERY = 65L;
        public static final long HKDF = 66L;
        public static final long X9_42_DH = 4L;
        public static final long KEA = 5L;
        public static final long GENERIC_SECRET = 16L;
        public static final long RC2 = 17L;
        public static final long RC4 = 18L;
        public static final long DES = 19L;
        public static final long DES2 = 20L;
        public static final long DES3 = 21L;
        public static final long CAST = 22L;
        public static final long CAST3 = 23L;
        public static final long CAST128 = 24L;
        public static final long RC5 = 25L;
        public static final long IDEA = 26L;
        public static final long SKIPJACK = 27L;
        public static final long BATON = 28L;
        public static final long JUNIPER = 29L;
        public static final long CDMF = 30L;
        public static final long AES = 31L;
        public static final long BLOWFISH = 32L;
        public static final long TWOFISH = 33L;
        public static final long VENDOR_SM2 = 0xFFFFF001L;
        public static final long VENDOR_SM4 = 0xFFFFF002L;
        public static final long VENDOR_DEFINED = 0x80000000L;
    }
}

