/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import java.util.Arrays;

public class MechanismArrayAttribute
extends Attribute {
    public MechanismArrayAttribute(Long type) {
        super(type);
    }

    public void setMechanismAttributeArrayValue(Mechanism[] value) {
        long[] values = null;
        if (value != null) {
            values = new long[value.length];
            for (int i = 0; i < value.length; ++i) {
                values[i] = value[i].getMechanismCode();
            }
        }
        this.ckAttribute.pValue = values;
        this.present = true;
    }

    public Mechanism[] getMechanismAttributeArrayValue() {
        long[] values;
        Mechanism[] mechanisms = null;
        if (this.ckAttribute.pValue != null && (values = (long[])this.ckAttribute.pValue).length > 0) {
            mechanisms = new Mechanism[values.length];
            for (int i = 0; i < values.length; ++i) {
                mechanisms[i] = new Mechanism(values[i]);
            }
        }
        return mechanisms;
    }

    @Override
    protected String getValueString() {
        StringBuilder sb = new StringBuilder(1024);
        Mechanism[] allowedMechanisms = this.getMechanismAttributeArrayValue();
        if (allowedMechanisms != null && allowedMechanisms.length > 0) {
            for (Mechanism allowedMechanism : allowedMechanisms) {
                sb.append("\n      ").append(allowedMechanism.getName());
            }
            return sb.toString();
        }
        return "<NULL_PTR>";
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof MechanismArrayAttribute)) {
            return false;
        }
        MechanismArrayAttribute other = (MechanismArrayAttribute)otherObject;
        if (!this.present && !other.present) {
            return true;
        }
        if (!this.present || !other.present) {
            return false;
        }
        if (this.sensitive != other.sensitive) {
            return false;
        }
        return Arrays.equals((long[])this.ckAttribute.pValue, (long[])other.ckAttribute.pValue);
    }

    @Override
    public int hashCode() {
        return this.ckAttribute.pValue != null ? Util.hashCode((long[])this.ckAttribute.pValue) : 0;
    }

    @Override
    public void setValue(Object value) {
        this.setMechanismAttributeArrayValue((Mechanism[])value);
    }
}

