/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.UnsupportedAttributeException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.VendorCodeConverter;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.Data;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Mechanism;
import iaik.pkcs.pkcs11.objects.ObjectClassAttribute;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11;

public class PKCS11Object {
    protected static VendorDefinedObjectBuilder vendorObjectBuilder;
    protected static Hashtable<Long, String> objectClassNames;
    protected Hashtable<Long, Attribute> attributeTable = new Hashtable(32);
    protected ObjectClassAttribute objectClass;
    protected long objectHandle = -1L;

    public PKCS11Object() {
        this.allocateAttributes();
    }

    protected PKCS11Object(Session session, long objectHandle) throws TokenException {
        this.allocateAttributes();
        this.objectHandle = objectHandle;
        this.readAttributes(session);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        ObjectClassAttribute objectClassAttribute = new ObjectClassAttribute();
        PKCS11Object.getAttributeValue(session, objectHandle, objectClassAttribute);
        Long objectClass = objectClassAttribute.getLongValue();
        PKCS11Object newObject = objectClassAttribute.isPresent() && objectClass != null ? (objectClass.equals(3L) ? PrivateKey.getInstance(session, objectHandle) : (objectClass.equals(2L) ? PublicKey.getInstance(session, objectHandle) : (objectClass.equals(1L) ? Certificate.getInstance(session, objectHandle) : (objectClass.equals(4L) ? SecretKey.getInstance(session, objectHandle) : (objectClass.equals(0L) ? Data.getInstance(session, objectHandle) : (objectClass.equals(6L) ? DomainParameters.getInstance(session, objectHandle) : (objectClass.equals(7L) ? Mechanism.getInstance(session, objectHandle) : (objectClass.equals(5L) ? HardwareFeature.getInstance(session, objectHandle) : ((objectClass & 0x80000000L) != 0L ? PKCS11Object.getUnknownObject(session, objectHandle) : PKCS11Object.getUnknownObject(session, objectHandle)))))))))) : PKCS11Object.getUnknownObject(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownObject(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (vendorObjectBuilder != null) {
            try {
                newObject = vendorObjectBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new PKCS11Object(session, objectHandle);
            }
        } else {
            newObject = new PKCS11Object(session, objectHandle);
        }
        return newObject;
    }

    public static void setVendorDefinedObjectBuilder(VendorDefinedObjectBuilder builder) {
        vendorObjectBuilder = builder;
    }

    public static String getObjectClassName(Long objectClass) {
        String objectClassName;
        Util.requireNonNull("objectClass", objectClass);
        if ((objectClass & 0x80000000L) != 0L) {
            objectClassName = "Vendor Defined";
        } else {
            if (objectClassNames == null) {
                objectClassNames = new Hashtable(7);
                objectClassNames.put(0L, "Data");
                objectClassNames.put(1L, "Certificate");
                objectClassNames.put(2L, "Public Key");
                objectClassNames.put(3L, "Private Key");
                objectClassNames.put(4L, "Secret Key");
                objectClassNames.put(5L, "Hardware Feature");
                objectClassNames.put(6L, "Domain Parameters");
            }
            if ((objectClassName = objectClassNames.get(objectClass)) == null) {
                objectClassName = "<unknown>";
            }
        }
        return objectClassName;
    }

    public static VendorDefinedObjectBuilder getVendorDefinedObjectBuilder() {
        return vendorObjectBuilder;
    }

    protected static void putAttributesInTable(PKCS11Object object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(0L, object.objectClass);
    }

    protected void allocateAttributes() {
        this.objectClass = new ObjectClassAttribute();
        PKCS11Object.putAttributesInTable(this);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PKCS11Object)) {
            return false;
        }
        PKCS11Object other = (PKCS11Object)otherObject;
        return this.objectHandle == other.objectHandle && this.objectClass.equals(other.objectClass);
    }

    public Hashtable<Long, Attribute> getAttributeTable() {
        return (Hashtable)this.attributeTable.clone();
    }

    public void putAttribute(long attribute, Object value) throws UnsupportedAttributeException {
        Attribute myAttribute = this.getAttribute(attribute);
        if (null == myAttribute) {
            throw new UnsupportedAttributeException("Unsupported attribute 0x" + Long.toHexString(attribute) + " for " + this.getClass().getName());
        }
        myAttribute.setValue(value);
    }

    public Attribute getAttribute(long attribute) {
        return this.attributeTable.get(attribute);
    }

    public void removeAttribute(long attribute) {
        this.getAttribute(attribute).setPresent(false);
    }

    public long getObjectHandle() {
        return this.objectHandle;
    }

    public void setObjectHandle(long objectHandle) {
        this.objectHandle = objectHandle;
    }

    public LongAttribute getObjectClass() {
        return this.objectClass;
    }

    public Vector<CK_ATTRIBUTE> getSetAttributes() {
        Vector<CK_ATTRIBUTE> attributeCollection = new Vector<CK_ATTRIBUTE>(this.attributeTable.size());
        Enumeration<Attribute> attributeEnumeration = this.attributeTable.elements();
        while (attributeEnumeration.hasMoreElements()) {
            Attribute attribute = attributeEnumeration.nextElement();
            if (!attribute.isPresent()) continue;
            CK_ATTRIBUTE ckAttribute = attribute.getCkAttribute();
            attributeCollection.addElement(ckAttribute);
        }
        return attributeCollection;
    }

    public static CK_ATTRIBUTE[] getSetAttributes(PKCS11Object object, VendorCodeConverter vendorCodeConverter) throws PKCS11Exception {
        long vendorKeyType;
        Long keyType;
        Vector<CK_ATTRIBUTE> setAttributes;
        Vector<CK_ATTRIBUTE> vector = setAttributes = object != null ? object.getSetAttributes() : null;
        if (setAttributes == null) {
            return null;
        }
        if (object instanceof Key && vendorCodeConverter != null && (keyType = ((Key)object).getKeyType().getLongValue()) != null && (keyType & 0x80000000L) != 0L && (vendorKeyType = vendorCodeConverter.genericToVendorCKK(keyType)) != keyType) {
            Vector<CK_ATTRIBUTE> newSetAttributes = new Vector<CK_ATTRIBUTE>();
            for (CK_ATTRIBUTE attr : setAttributes) {
                if (attr.type == 256L) {
                    attr = new CK_ATTRIBUTE(attr.type, vendorKeyType);
                }
                newSetAttributes.add(attr);
            }
            setAttributes = newSetAttributes;
        }
        return Util.convertAttributesVectorToArray(setAttributes);
    }

    public int hashCode() {
        return this.objectClass.hashCode() ^ (int)this.objectHandle;
    }

    public void readAttributes(Session session) throws TokenException {
        Util.requireNonNull("session", session);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("  PKCS11Object Class: ");
        if (this.objectClass != null) {
            sb.append(this.objectClass.toString());
        } else {
            sb.append("<unavailable>");
        }
        return sb.toString();
    }

    public String toString(boolean newline, boolean withName, String indent) {
        boolean firstAttribute;
        StringBuilder sb = new StringBuilder(1024);
        Enumeration<Attribute> attributesEnumeration = this.attributeTable.elements();
        boolean bl = firstAttribute = !newline;
        while (attributesEnumeration.hasMoreElements()) {
            Attribute attribute = attributesEnumeration.nextElement();
            if (!attribute.isPresent()) continue;
            if (!firstAttribute) {
                sb.append("\n");
            }
            sb.append(indent);
            sb.append(attribute.toString(withName));
            firstAttribute = false;
        }
        return sb.toString();
    }

    protected static void getAttributeValue(Session session, long objectHandle, Attribute attribute) throws PKCS11Exception {
        Util.requireNonNull("session", session);
        PKCS11 pkcs11Module = session.getModule().getPKCS11Module();
        long sessionHandle = session.getSessionHandle();
        long attributeCode = attribute.getCkAttribute().type;
        try {
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            attributeTemplateList[0].type = attributeCode;
            pkcs11Module.C_GetAttributeValue(sessionHandle, objectHandle, attributeTemplateList);
            attribute.setCkAttribute(attributeTemplateList[0]);
            attribute.setPresent(true);
            attribute.setSensitive(false);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            if (ex.getErrorCode() == 18L) {
                attribute.setPresent(false);
            }
            if (ex.getErrorCode() == 17L) {
                attribute.setPresent(true);
                attribute.setSensitive(true);
            }
            throw new PKCS11Exception(ex);
        }
    }

    protected static void getAttributeValues(Session session, long objectHandle, Attribute[] attributes) throws PKCS11Exception {
        Util.requireNonNull("session", session);
        Util.requireNonNull("attributes", attributes);
        PKCS11 pkcs11Module = session.getModule().getPKCS11Module();
        long sessionHandle = session.getSessionHandle();
        try {
            int i;
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[attributes.length];
            for (i = 0; i < attributes.length; ++i) {
                CK_ATTRIBUTE attribute = new CK_ATTRIBUTE();
                attribute.type = attributes[i].getCkAttribute().type;
                attributeTemplateList[i] = attribute;
            }
            pkcs11Module.C_GetAttributeValue(sessionHandle, objectHandle, attributeTemplateList);
            for (i = 0; i < attributes.length; ++i) {
                attributes[i].setCkAttribute(attributeTemplateList[i]);
                attributes[i].setPresent(true);
                attributes[i].setSensitive(false);
            }
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            for (Attribute attribute : attributes) {
                PKCS11Object.getAttributeValue(session, objectHandle, attribute);
            }
        }
    }

    public static interface VendorDefinedObjectBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }

    public static interface ObjectClass {
        public static final long DATA = 0L;
        public static final long CERTIFICATE = 1L;
        public static final long PUBLIC_KEY = 2L;
        public static final long PRIVATE_KEY = 3L;
        public static final long SECRET_KEY = 4L;
        public static final long HW_FEATURE = 5L;
        public static final long DOMAIN_PARAMETERS = 6L;
        public static final long MECHANISM = 7L;
        public static final long VENDOR_DEFINED = 0x80000000L;
    }
}

