/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.VendorCodeConverter;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X942DHPrivateKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PrivateKey
extends Key {
    protected ByteArrayAttribute subject;
    protected BooleanAttribute sensitive;
    protected BooleanAttribute secondaryAuth;
    protected LongAttribute authPinFlags;
    protected BooleanAttribute decrypt;
    protected BooleanAttribute sign;
    protected BooleanAttribute signRecover;
    protected BooleanAttribute unwrap;
    protected BooleanAttribute extractable;
    protected BooleanAttribute alwaysSensitive;
    protected BooleanAttribute neverExtractable;
    protected BooleanAttribute wrapWithTrusted;
    protected AttributeArray unwrapTemplate;
    protected BooleanAttribute alwaysAuthenticate;

    public PrivateKey() {
        this.objectClass.setLongValue(3L);
    }

    protected PrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(3L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        PrivateKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = null;
        if (keyTypeAttribute.isPresent() && keyType != null) {
            VendorCodeConverter converter;
            if (keyType.equals(0L)) {
                newObject = RSAPrivateKey.getInstance(session, objectHandle);
            } else if (keyType.equals(1L)) {
                newObject = DSAPrivateKey.getInstance(session, objectHandle);
            } else if (keyType.equals(3L) | keyType.equals(64L) | keyType.equals(65L)) {
                newObject = ECPrivateKey.getInstance(session, objectHandle);
            } else if (keyType.equals(2L)) {
                newObject = DHPrivateKey.getInstance(session, objectHandle);
            } else if (keyType.equals(5L)) {
                newObject = KEAPrivateKey.getInstance(session, objectHandle);
            } else if (keyType.equals(4L)) {
                newObject = X942DHPrivateKey.getInstance(session, objectHandle);
            } else if ((keyType & 0x80000000L) != 0L && (converter = session.getModule().getVendorCodeConverter()) != null && converter.vendorToGenericCKK(keyType) == 0xFFFFF001L) {
                newObject = ECPrivateKey.getInstance(session, objectHandle);
                ((Key)newObject).keyType.setLongValue(keyType);
            }
        }
        if (newObject == null) {
            newObject = PrivateKey.getUnknownPrivateKey(session, objectHandle);
        }
        return newObject;
    }

    protected static PKCS11Object getUnknownPrivateKey(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        Key.VendorDefinedKeyBuilder vendorKeyBuilder = session.getModule().getVendorDefinedKeyBuilder();
        if (vendorKeyBuilder != null) {
            try {
                newObject = vendorKeyBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new PrivateKey(session, objectHandle);
            }
        } else {
            newObject = new PrivateKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(PrivateKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(257L, object.subject);
        object.attributeTable.put(259L, object.sensitive);
        object.attributeTable.put(512L, object.secondaryAuth);
        object.attributeTable.put(513L, object.authPinFlags);
        object.attributeTable.put(261L, object.decrypt);
        object.attributeTable.put(264L, object.sign);
        object.attributeTable.put(265L, object.signRecover);
        object.attributeTable.put(263L, object.unwrap);
        object.attributeTable.put(354L, object.extractable);
        object.attributeTable.put(357L, object.alwaysSensitive);
        object.attributeTable.put(356L, object.neverExtractable);
        object.attributeTable.put(528L, object.wrapWithTrusted);
        object.attributeTable.put(1073742354L, object.unwrapTemplate);
        object.attributeTable.put(514L, object.alwaysAuthenticate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute((Long)257L);
        this.sensitive = new BooleanAttribute((Long)259L);
        this.secondaryAuth = new BooleanAttribute((Long)512L);
        this.authPinFlags = new LongAttribute((Long)513L);
        this.decrypt = new BooleanAttribute((Long)261L);
        this.sign = new BooleanAttribute((Long)264L);
        this.signRecover = new BooleanAttribute((Long)265L);
        this.unwrap = new BooleanAttribute((Long)263L);
        this.extractable = new BooleanAttribute((Long)354L);
        this.alwaysSensitive = new BooleanAttribute((Long)357L);
        this.neverExtractable = new BooleanAttribute((Long)356L);
        this.wrapWithTrusted = new BooleanAttribute((Long)528L);
        this.unwrapTemplate = new AttributeArray((Long)1073742354L);
        this.alwaysAuthenticate = new BooleanAttribute((Long)514L);
        PrivateKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PrivateKey)) {
            return false;
        }
        PrivateKey other = (PrivateKey)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.sensitive.equals(other.sensitive) && this.secondaryAuth.equals(other.secondaryAuth) && this.authPinFlags.equals(other.authPinFlags) && this.decrypt.equals(other.decrypt) && this.sign.equals(other.sign) && this.signRecover.equals(other.signRecover) && this.unwrap.equals(other.unwrap) && this.extractable.equals(other.extractable) && this.alwaysSensitive.equals(other.alwaysSensitive) && this.neverExtractable.equals(other.neverExtractable) && this.wrapWithTrusted.equals(other.wrapWithTrusted) && this.unwrapTemplate.equals(other.unwrapTemplate) && this.alwaysAuthenticate.equals(other.alwaysAuthenticate);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public BooleanAttribute getSensitive() {
        return this.sensitive;
    }

    public BooleanAttribute getSecondaryAuth() {
        return this.secondaryAuth;
    }

    public LongAttribute getAuthPinFlags() {
        return this.authPinFlags;
    }

    public BooleanAttribute getDecrypt() {
        return this.decrypt;
    }

    public BooleanAttribute getSign() {
        return this.sign;
    }

    public BooleanAttribute getSignRecover() {
        return this.signRecover;
    }

    public BooleanAttribute getUnwrap() {
        return this.unwrap;
    }

    public BooleanAttribute getExtractable() {
        return this.extractable;
    }

    public BooleanAttribute getAlwaysSensitive() {
        return this.alwaysSensitive;
    }

    public BooleanAttribute getNeverExtractable() {
        return this.neverExtractable;
    }

    public BooleanAttribute getWrapWithTrusted() {
        return this.wrapWithTrusted;
    }

    public AttributeArray getUnwrapTemplate() {
        return this.unwrapTemplate;
    }

    public BooleanAttribute getAlwaysAuthenticate() {
        return this.alwaysAuthenticate;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.sensitive, this.secondaryAuth, this.authPinFlags, this.decrypt, this.sign, this.signRecover, this.unwrap, this.extractable, this.alwaysSensitive, this.neverExtractable, this.wrapWithTrusted, this.alwaysAuthenticate, this.unwrapTemplate});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n  Subject (DER, hex): ").append(this.subject);
        sb.append("\n  Sensitive: ").append(this.sensitive);
        sb.append("\n  Secondary Authentication: ").append(this.secondaryAuth);
        sb.append("\n  Secondary Authentication PIN Flags: ");
        if (this.authPinFlags.isPresent() && !this.authPinFlags.isSensitive() && this.authPinFlags.getLongValue() != null) {
            long authFlagsValue = this.authPinFlags.getLongValue();
            sb.append("\n    User PIN-Count low: ").append((authFlagsValue & 0x10000L) != 0L);
            sb.append("\n    User PIN final Try: ").append((authFlagsValue & 0x20000L) != 0L);
            sb.append("\n    User PIN locked: ").append((authFlagsValue & 0x40000L) != 0L);
            sb.append("\n    User PIN to be changed: ").append((authFlagsValue & 0x80000L) != 0L);
        } else {
            sb.append(this.authPinFlags);
        }
        sb.append("\n  Decrypt: ").append(this.decrypt);
        sb.append("\n  Sign: ").append(this.sign);
        sb.append("\n  Sign Recover: ").append(this.signRecover);
        sb.append("\n  Unwrap: ").append(this.unwrap);
        sb.append("\n  Extractable: ").append(this.extractable);
        sb.append("\n  Always Sensitive: ").append(this.alwaysSensitive);
        sb.append("\n  Never Extractable: ").append(this.neverExtractable);
        sb.append("\n  Wrap With Trusted: ").append(this.wrapWithTrusted);
        sb.append("\n  Unwrap Template: ").append(this.unwrapTemplate);
        sb.append("\n  Always Authenticate: ").append(this.alwaysAuthenticate);
        return sb.toString();
    }
}

