/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.VendorCodeConverter;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECPublicKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PublicKey
extends Key {
    protected ByteArrayAttribute subject;
    protected BooleanAttribute encrypt;
    protected BooleanAttribute verify;
    protected BooleanAttribute verifyRecover;
    protected BooleanAttribute wrap;
    protected BooleanAttribute trusted;
    protected AttributeArray wrapTemplate;

    public PublicKey() {
        this.objectClass.setLongValue(2L);
    }

    protected PublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(2L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        PublicKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = null;
        if (keyTypeAttribute.isPresent() && keyType != null) {
            VendorCodeConverter converter;
            if (keyType.equals(0L)) {
                newObject = RSAPublicKey.getInstance(session, objectHandle);
            } else if (keyType.equals(1L)) {
                newObject = DSAPublicKey.getInstance(session, objectHandle);
            } else if (keyType.equals(3L) | keyType.equals(64L) | keyType.equals(65L)) {
                newObject = ECPublicKey.getInstance(session, objectHandle);
            } else if (keyType.equals(2L)) {
                newObject = DHPublicKey.getInstance(session, objectHandle);
            } else if (keyType.equals(5L)) {
                newObject = KEAPublicKey.getInstance(session, objectHandle);
            } else if (keyType.equals(4L)) {
                newObject = X942DHPublicKey.getInstance(session, objectHandle);
            } else if ((keyType & 0x80000000L) != 0L && (converter = session.getModule().getVendorCodeConverter()) != null && converter.vendorToGenericCKK(keyType) == 0xFFFFF001L) {
                newObject = ECPublicKey.getInstance(session, objectHandle);
                ((Key)newObject).keyType.setLongValue(keyType);
            }
        }
        if (newObject == null) {
            newObject = PublicKey.getUnknownPublicKey(session, objectHandle);
        }
        return newObject;
    }

    protected static PKCS11Object getUnknownPublicKey(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        Key.VendorDefinedKeyBuilder vendorKeyBuilder = session.getModule().getVendorDefinedKeyBuilder();
        if (vendorKeyBuilder != null) {
            try {
                newObject = vendorKeyBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new PublicKey(session, objectHandle);
            }
        } else {
            newObject = new PublicKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(PublicKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(257L, object.subject);
        object.attributeTable.put(260L, object.encrypt);
        object.attributeTable.put(266L, object.verify);
        object.attributeTable.put(267L, object.verifyRecover);
        object.attributeTable.put(262L, object.wrap);
        object.attributeTable.put(134L, object.trusted);
        object.attributeTable.put(1073742353L, object.wrapTemplate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute((Long)257L);
        this.encrypt = new BooleanAttribute((Long)260L);
        this.verify = new BooleanAttribute((Long)266L);
        this.verifyRecover = new BooleanAttribute((Long)267L);
        this.wrap = new BooleanAttribute((Long)262L);
        this.trusted = new BooleanAttribute((Long)134L);
        this.wrapTemplate = new AttributeArray((Long)1073742353L);
        PublicKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.encrypt.equals(other.encrypt) && this.verify.equals(other.verify) && this.verifyRecover.equals(other.verifyRecover) && this.wrap.equals(other.wrap) && this.trusted.equals(other.trusted) && this.wrapTemplate.equals(other.wrapTemplate);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt;
    }

    public BooleanAttribute getVerify() {
        return this.verify;
    }

    public BooleanAttribute getVerifyRecover() {
        return this.verifyRecover;
    }

    public BooleanAttribute getWrap() {
        return this.wrap;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted;
    }

    public AttributeArray getWrapTemplate() {
        return this.wrapTemplate;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.encrypt, this.verify, this.verifyRecover, this.wrap, this.trusted, this.wrapTemplate});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Subject (DER, hex): ", this.subject, "\n  Encrypt: ", this.encrypt, "\n  Verify: ", this.verify, "\n  Verify Recover: ", this.verifyRecover, "\n  Wrap: ", this.wrap, "\n  Trusted: ", this.trusted, "\n  Wrap Template: ", this.wrapTemplate);
    }
}

