/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.ValuedSecretKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class SecretKey
extends Key {
    protected BooleanAttribute sensitive;
    protected BooleanAttribute encrypt;
    protected BooleanAttribute decrypt;
    protected BooleanAttribute sign;
    protected BooleanAttribute verify;
    protected BooleanAttribute wrap;
    protected BooleanAttribute unwrap;
    protected BooleanAttribute extractable;
    protected BooleanAttribute alwaysSensitive;
    protected BooleanAttribute neverExtractable;
    protected ByteArrayAttribute checkValue;
    protected BooleanAttribute wrapWithTrusted;
    protected BooleanAttribute trusted;
    protected AttributeArray wrapTemplate;
    protected AttributeArray unwrapTemplate;

    public SecretKey() {
        this.objectClass.setLongValue(4L);
    }

    protected SecretKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(4L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        SecretKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = keyTypeAttribute.isPresent() && keyType != null ? ValuedSecretKey.getInstance(session, objectHandle, keyType) : SecretKey.getUnknownSecretKey(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownSecretKey(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        Key.VendorDefinedKeyBuilder vendorKeyBuilder = session.getModule().getVendorDefinedKeyBuilder();
        if (vendorKeyBuilder != null) {
            try {
                newObject = vendorKeyBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new SecretKey(session, objectHandle);
            }
        } else {
            newObject = new SecretKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(SecretKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(259L, object.sensitive);
        object.attributeTable.put(260L, object.encrypt);
        object.attributeTable.put(261L, object.decrypt);
        object.attributeTable.put(264L, object.sign);
        object.attributeTable.put(266L, object.verify);
        object.attributeTable.put(262L, object.wrap);
        object.attributeTable.put(263L, object.unwrap);
        object.attributeTable.put(354L, object.extractable);
        object.attributeTable.put(357L, object.alwaysSensitive);
        object.attributeTable.put(356L, object.neverExtractable);
        object.attributeTable.put(144L, object.checkValue);
        object.attributeTable.put(528L, object.wrapWithTrusted);
        object.attributeTable.put(134L, object.trusted);
        object.attributeTable.put(1073742353L, object.wrapTemplate);
        object.attributeTable.put(1073742354L, object.unwrapTemplate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.sensitive = new BooleanAttribute((Long)259L);
        this.encrypt = new BooleanAttribute((Long)260L);
        this.decrypt = new BooleanAttribute((Long)261L);
        this.sign = new BooleanAttribute((Long)264L);
        this.verify = new BooleanAttribute((Long)266L);
        this.wrap = new BooleanAttribute((Long)262L);
        this.unwrap = new BooleanAttribute((Long)263L);
        this.extractable = new BooleanAttribute((Long)354L);
        this.alwaysSensitive = new BooleanAttribute((Long)357L);
        this.neverExtractable = new BooleanAttribute((Long)356L);
        this.checkValue = new ByteArrayAttribute((Long)144L);
        this.wrapWithTrusted = new BooleanAttribute((Long)528L);
        this.trusted = new BooleanAttribute((Long)134L);
        this.wrapTemplate = new AttributeArray((Long)1073742353L);
        this.unwrapTemplate = new AttributeArray((Long)1073742354L);
        SecretKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SecretKey)) {
            return false;
        }
        SecretKey other = (SecretKey)otherObject;
        return super.equals(other) && this.sensitive.equals(other.sensitive) && this.encrypt.equals(other.encrypt) && this.decrypt.equals(other.decrypt) && this.sign.equals(other.sign) && this.verify.equals(other.verify) && this.wrap.equals(other.wrap) && this.unwrap.equals(other.unwrap) && this.extractable.equals(other.extractable) && this.alwaysSensitive.equals(other.alwaysSensitive) && this.neverExtractable.equals(other.neverExtractable) && this.checkValue.equals(other.checkValue) && this.wrapWithTrusted.equals(other.wrapWithTrusted) && this.trusted.equals(other.trusted) && this.wrapTemplate.equals(other.wrapTemplate) && this.unwrapTemplate.equals(other.unwrapTemplate);
    }

    public BooleanAttribute getSensitive() {
        return this.sensitive;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt;
    }

    public BooleanAttribute getVerify() {
        return this.verify;
    }

    public BooleanAttribute getDecrypt() {
        return this.decrypt;
    }

    public BooleanAttribute getSign() {
        return this.sign;
    }

    public BooleanAttribute getWrap() {
        return this.wrap;
    }

    public BooleanAttribute getUnwrap() {
        return this.unwrap;
    }

    public BooleanAttribute getExtractable() {
        return this.extractable;
    }

    public BooleanAttribute getAlwaysSensitive() {
        return this.alwaysSensitive;
    }

    public BooleanAttribute getNeverExtractable() {
        return this.neverExtractable;
    }

    public ByteArrayAttribute getCheckValue() {
        return this.checkValue;
    }

    public BooleanAttribute getWrapWithTrusted() {
        return this.wrapWithTrusted;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted;
    }

    public AttributeArray getWrapTemplate() {
        return this.wrapTemplate;
    }

    public AttributeArray getUnwrapTemplate() {
        return this.unwrapTemplate;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.sensitive, this.encrypt, this.decrypt, this.sign, this.verify, this.wrap, this.unwrap, this.extractable, this.alwaysSensitive, this.neverExtractable, this.checkValue, this.wrapWithTrusted, this.trusted, this.wrapTemplate, this.unwrapTemplate});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 200, superToString, "\n  Sensitive: ", this.sensitive, "\n  Encrypt: ", this.encrypt, "\n  Decrypt: ", this.decrypt, "\n  Sign: ", this.sign, "\n  Verify: ", this.verify, "\n  Wrap: ", this.wrap, "\n  Unwrap: ", this.unwrap, "\n  Extractable: ", this.extractable, "\n  Always Sensitive: ", this.alwaysSensitive, "\n  Never Extractable: ", this.neverExtractable, "\n  Check Value: ", this.checkValue, "\n  Wrap With Trusted: ", this.wrapWithTrusted, "\n  Trusted: ", this.trusted, "\n  Wrap Template: ", this.wrapTemplate, "\n  Unwrap Template: ", this.unwrapTemplate);
    }
}

