/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class Storage
extends PKCS11Object {
    protected BooleanAttribute token;
    protected BooleanAttribute private_;
    protected BooleanAttribute modifiable;
    protected CharArrayAttribute label;

    public Storage() {
    }

    protected Storage(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
    }

    protected static void putAttributesInTable(Storage object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(1L, object.token);
        object.attributeTable.put(2L, object.private_);
        object.attributeTable.put(368L, object.modifiable);
        object.attributeTable.put(3L, object.label);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.token = new BooleanAttribute((Long)1L);
        this.private_ = new BooleanAttribute((Long)2L);
        this.modifiable = new BooleanAttribute((Long)368L);
        this.label = new CharArrayAttribute(3L);
        Storage.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Storage)) {
            return false;
        }
        Storage other = (Storage)otherObject;
        return super.equals(other) && this.token.equals(other.token) && this.private_.equals(other.private_) && this.modifiable.equals(other.modifiable) && this.label.equals(other.label);
    }

    public BooleanAttribute getToken() {
        return this.token;
    }

    public BooleanAttribute getPrivate() {
        return this.private_;
    }

    public BooleanAttribute getModifiable() {
        return this.modifiable;
    }

    public CharArrayAttribute getLabel() {
        return this.label;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.token, this.private_, this.modifiable, this.label});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Token: ", this.token, "\n  Private: ", this.private_, "\n  Modifiable: ", this.modifiable, "\n  Label: ", this.label);
    }

    @Override
    public int hashCode() {
        return this.token.hashCode() ^ this.private_.hashCode() ^ this.modifiable.hashCode() ^ this.label.hashCode();
    }
}

