/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class X509AttributeCertificate
extends Certificate {
    protected ByteArrayAttribute owner;
    protected ByteArrayAttribute acIssuer;
    protected ByteArrayAttribute serialNumber;
    protected ByteArrayAttribute attrTypes;
    protected ByteArrayAttribute value;

    public X509AttributeCertificate() {
        this.certificateType.setLongValue(1L);
    }

    protected X509AttributeCertificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.certificateType.setLongValue(1L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X509AttributeCertificate(session, objectHandle);
    }

    protected static void putAttributesInTable(X509AttributeCertificate object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(132L, object.owner);
        object.attributeTable.put(131L, object.acIssuer);
        object.attributeTable.put(130L, object.serialNumber);
        object.attributeTable.put(133L, object.attrTypes);
        object.attributeTable.put(17L, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.owner = new ByteArrayAttribute((Long)132L);
        this.acIssuer = new ByteArrayAttribute((Long)131L);
        this.serialNumber = new ByteArrayAttribute((Long)130L);
        this.attrTypes = new ByteArrayAttribute((Long)133L);
        this.value = new ByteArrayAttribute((Long)17L);
        X509AttributeCertificate.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X509AttributeCertificate)) {
            return false;
        }
        X509AttributeCertificate other = (X509AttributeCertificate)otherObject;
        return super.equals(other) && this.owner.equals(other.owner) && this.acIssuer.equals(other.acIssuer) && this.serialNumber.equals(other.serialNumber) && this.attrTypes.equals(other.attrTypes) && this.value.equals(other.value);
    }

    public ByteArrayAttribute getOwner() {
        return this.owner;
    }

    public ByteArrayAttribute getAcIssuer() {
        return this.acIssuer;
    }

    public ByteArrayAttribute getSerialNumber() {
        return this.serialNumber;
    }

    public ByteArrayAttribute getAttrTypes() {
        return this.attrTypes;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.acIssuer.hashCode() ^ this.serialNumber.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.owner, this.acIssuer, this.serialNumber, this.attrTypes, this.value});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Owner (DER, hex): ", this.owner, "\n  Attribute Certificate Issuer (DER, hex): ", this.acIssuer, "\n  Serial Number (DER, hex): ", this.serialNumber, "\n  Attribute Types (BER, hex): ", this.attrTypes, "\n  Value (BER, hex): ", this.value);
    }
}

