/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class X942DHPublicKey
extends DHPublicKey {
    protected ByteArrayAttribute subprime;

    public X942DHPublicKey() {
        this.keyType.setLongValue(4L);
    }

    protected X942DHPublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(4L);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X942DHPublicKey(session, objectHandle);
    }

    protected static void putAttributesInTable(X942DHPublicKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(304L, object.prime);
        object.attributeTable.put(306L, object.base);
        object.attributeTable.put(305L, object.subprime);
        object.attributeTable.put(17L, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute((Long)304L);
        this.base = new ByteArrayAttribute((Long)306L);
        this.subprime = new ByteArrayAttribute((Long)305L);
        this.value = new ByteArrayAttribute((Long)17L);
        X942DHPublicKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X942DHPublicKey)) {
            return false;
        }
        X942DHPublicKey other = (X942DHPublicKey)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.base.equals(other.base) && this.subprime.equals(other.subprime) && this.value.equals(other.value);
    }

    @Override
    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    @Override
    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime;
    }

    @Override
    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.base, this.subprime, this.value});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Base (hex): ", this.base, "\n  Subprime (hex): ", this.subprime, "\n  Value (hex): ", this.value);
    }
}

