/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class CCMParameters
implements Parameters {
    public static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_CCM_PARAMS";
    private static final Constructor<?> constructor = Util.getConstructor("sun.security.pkcs11.wrapper.CK_CCM_PARAMS", Integer.TYPE, byte[].class, byte[].class, Integer.TYPE);
    private final int dataLen;
    private final byte[] iv;
    private final byte[] aad;
    private final int tagLen;

    public CCMParameters(int tagLen, byte[] iv, byte[] aad, int dataLen) {
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_CCM_PARAMS is not available in the JDK");
        }
        this.dataLen = dataLen;
        this.iv = iv;
        this.aad = aad;
        this.tagLen = tagLen;
    }

    public String toString() {
        return Util.concatObjectsCap(100, "\n  ulDataLen: ", this.dataLen, "\n  iv: ", Functions.toHexString(this.iv), "\n  aad: ", Functions.toHexString(this.aad), "\n  tagLen: ", this.tagLen);
    }

    public int hashCode() {
        return this.dataLen ^ Util.hashCode(this.iv) ^ Util.hashCode(this.aad) ^ this.tagLen;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        try {
            return constructor.newInstance(this.tagLen, this.iv, this.aad, this.dataLen);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_CCM_PARAMS", ex);
        }
    }
}

