/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.parameters.DHKeyDerivationParameters;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_ECDH2_DERIVE_PARAMS;

public class EcDH2KeyDerivationParameters
extends DHKeyDerivationParameters {
    protected byte[] sharedData;
    protected long privateDataLength;
    protected PKCS11Object privateData;
    protected byte[] publicData2;

    public EcDH2KeyDerivationParameters(long kdf, byte[] sharedData, byte[] publicData, long privateDataLength, PKCS11Object privateData, byte[] publicData2) {
        super(kdf, publicData);
        this.sharedData = sharedData;
        this.privateDataLength = privateDataLength;
        this.privateData = Util.requireNonNull("privateData", privateData);
        this.publicData2 = Util.requireNonNull("publicData2", publicData2);
    }

    @Override
    public CK_ECDH2_DERIVE_PARAMS getPKCS11ParamsObject() {
        CK_ECDH2_DERIVE_PARAMS params = new CK_ECDH2_DERIVE_PARAMS();
        params.kdf = this.kdf;
        params.pSharedData = this.sharedData;
        params.pPublicData = this.publicData;
        params.ulPrivateDataLen = this.privateDataLength;
        params.hPrivateData = this.privateData.getObjectHandle();
        params.pPublicData2 = this.publicData2;
        return params;
    }

    public byte[] getSharedData() {
        return this.sharedData;
    }

    public void setSharedData(byte[] sharedData) {
        this.sharedData = sharedData;
    }

    public PKCS11Object getPrivateData() {
        return this.privateData;
    }

    public long getPrivateDataLength() {
        return this.privateDataLength;
    }

    public byte[] getPublicData2() {
        return this.publicData2;
    }

    public void setPrivateData(PKCS11Object privateData) {
        this.privateData = Util.requireNonNull("privateData", privateData);
    }

    public void setPrivateDataLength(long privateDataLength) {
        this.privateDataLength = privateDataLength;
    }

    public void setPublicData2(byte[] publicData2) {
        this.publicData2 = Util.requireNonNull("publicData2", publicData2);
    }

    @Override
    public String toString() {
        String upperStr = super.toString();
        return Util.concatObjectsCap(upperStr.length() + 100, upperStr, "\n  Shared Data: ", Util.toHex(this.sharedData), "\n  Private Data Length (dec): ", this.privateDataLength, "\n  Private Data: ", this.privateData, "\n  Public Data 2: ", Util.toHex(this.publicData2));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof EcDH2KeyDerivationParameters)) {
            return false;
        }
        EcDH2KeyDerivationParameters other = (EcDH2KeyDerivationParameters)otherObject;
        return super.equals(other) && Arrays.equals(this.sharedData, other.sharedData) && this.privateDataLength == other.privateDataLength && this.privateData.equals(other.privateData) && Arrays.equals(this.publicData2, other.publicData2);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Util.hashCode(this.sharedData) ^ (int)this.privateDataLength ^ this.privateData.hashCode() ^ Util.hashCode(this.publicData2);
    }
}

