/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_PBE_PARAMS;

public class PBEParameters
implements Parameters {
    protected char[] iv;
    protected char[] password;
    protected char[] salt;
    protected long iterations;

    public PBEParameters(char[] iv, char[] password, char[] salt, long iterations) {
        if (iv != null && iv.length != 8) {
            throw new IllegalArgumentException("Argument \"iv\" must be null or must have length 8, if it is not null.");
        }
        this.iv = iv;
        this.password = Util.requireNonNull("password", password);
        this.salt = Util.requireNonNull("salt", salt);
        this.iterations = iterations;
    }

    @Override
    public CK_PBE_PARAMS getPKCS11ParamsObject() {
        CK_PBE_PARAMS params = new CK_PBE_PARAMS();
        params.pInitVector = (byte[])this.iv;
        params.pPassword = this.password;
        params.pSalt = (byte[])this.salt;
        params.ulIteration = this.iterations;
        return params;
    }

    public char[] getInitializationVector() {
        return this.iv;
    }

    public char[] getPassword() {
        return this.password;
    }

    public char[] getSalt() {
        return this.salt;
    }

    public long getIterations() {
        return this.iterations;
    }

    public void setInitializationVector(char[] iv) {
        if (iv != null && iv.length != 8) {
            throw new IllegalArgumentException("Argument \"iv\" must be null or must have length 8, if it is not null.");
        }
        this.iv = iv;
    }

    public void setPassword(char[] password) {
        this.password = Util.requireNonNull("password", password);
    }

    public void setSalt(char[] salt) {
        this.salt = Util.requireNonNull("salt", salt);
    }

    public void setIterations(long iterations) {
        this.iterations = iterations;
    }

    public String toString() {
        return Util.concatObjects("  IV: ", this.iv != null ? new String(this.iv) : null, "\n  Password: ", this.password != null ? new String(this.password) : null, "\n  Salt: ", this.salt != null ? new String(this.salt) : null, "\n  Iterations (dec): ", this.iterations);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PBEParameters)) {
            return false;
        }
        PBEParameters other = (PBEParameters)otherObject;
        return Arrays.equals(this.iv, other.iv) && Arrays.equals(this.password, other.password) && Arrays.equals(this.salt, other.salt) && this.iterations == other.iterations;
    }

    public int hashCode() {
        return Util.hashCode(this.iv) ^ Util.hashCode(this.password) ^ Util.hashCode(this.salt) ^ (int)this.iterations;
    }
}

