/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class RSAPkcsParameters
implements Parameters {
    protected static final Map<Long, Long> mgf2HashAlgMap;
    protected long hashAlg;
    protected long mgf;

    protected RSAPkcsParameters(long hashAlg, long mgf) {
        if (!mgf2HashAlgMap.containsKey(mgf)) {
            throw new IllegalArgumentException("Illegal value for argument\"mgf\": " + Long.toHexString(mgf));
        }
        this.hashAlg = hashAlg;
        this.mgf = mgf;
    }

    public long getHashAlgorithm() {
        return this.hashAlg;
    }

    public long getMaskGenerationFunction() {
        return this.mgf;
    }

    public void setHashAlgorithm(long hashAlg) {
        this.hashAlg = hashAlg;
    }

    public void setMaskGenerationFunction(long mgf) {
        if (!mgf2HashAlgMap.containsKey(mgf)) {
            throw new IllegalArgumentException("Illegal value for argument\"mgf\": " + Long.toHexString(mgf));
        }
        this.mgf = mgf;
    }

    public String toString() {
        String hashMech = Functions.mechanismCodeToString(this.hashAlg);
        String mgfMech = Functions.getMGFName(this.mgf);
        return Util.concat("  Hash Algorithm: ", hashMech, "\n  Mask Generation Function: ", mgfMech);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPkcsParameters)) {
            return false;
        }
        RSAPkcsParameters other = (RSAPkcsParameters)otherObject;
        return this.hashAlg == other.hashAlg && this.mgf == other.mgf;
    }

    public int hashCode() {
        return (int)this.hashAlg ^ (int)this.mgf;
    }

    static {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        map.put(1L, 544L);
        map.put(5L, 597L);
        map.put(2L, 592L);
        map.put(3L, 608L);
        map.put(4L, 624L);
        map.put(6L, 693L);
        map.put(7L, 688L);
        map.put(8L, 704L);
        map.put(9L, 720L);
        mgf2HashAlgMap = Collections.unmodifiableMap(map);
    }
}

