/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.RSAPkcsParameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS;

public class RSAPkcsPssParameters
extends RSAPkcsParameters {
    private static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS";
    private static final Constructor<?> constructor;
    private static final Constructor<?> constructorNoArgs;
    private static final Field hashAlgField;
    private static final Field mgfField;
    private static final Field sLenField;
    protected long saltLength;

    @Deprecated
    public RSAPkcsPssParameters(Mechanism hashAlg, long mgf, long saltLength) {
        this(hashAlg.getMechanismCode(), mgf, saltLength);
    }

    public RSAPkcsPssParameters(long hashAlg, long mgf, long saltLength) {
        super(hashAlg, mgf);
        if (constructor == null && constructorNoArgs == null) {
            throw new IllegalStateException("could not find constructor for class sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS");
        }
        this.saltLength = saltLength;
    }

    @Override
    public CK_RSA_PKCS_PSS_PARAMS getPKCS11ParamsObject() {
        if (constructorNoArgs != null) {
            try {
                CK_RSA_PKCS_PSS_PARAMS ret = (CK_RSA_PKCS_PSS_PARAMS)constructorNoArgs.newInstance(new Object[0]);
                hashAlgField.set(ret, this.hashAlg);
                mgfField.set(ret, this.mgf);
                sLenField.set(ret, this.saltLength);
                return ret;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS", ex);
            }
        }
        String hashAlgName = Functions.getHashAlgName(this.hashAlg);
        String mgfHashAlgName = Functions.getHashAlgName((Long)mgf2HashAlgMap.get(this.mgf));
        try {
            return (CK_RSA_PKCS_PSS_PARAMS)constructor.newInstance(hashAlgName, "MGF1", mgfHashAlgName, (int)this.saltLength);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS", ex);
        }
    }

    public long getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(long saltLength) {
        this.saltLength = saltLength;
    }

    @Override
    public String toString() {
        return Util.concat(super.toString(), "\n  Salt Length (octets, dec): ", Long.toString(this.saltLength));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPkcsPssParameters)) {
            return false;
        }
        RSAPkcsPssParameters other = (RSAPkcsPssParameters)otherObject;
        return super.equals(other) && this.saltLength == other.saltLength;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.saltLength;
    }

    static {
        Class<CK_RSA_PKCS_PSS_PARAMS> clazz = CK_RSA_PKCS_PSS_PARAMS.class;
        constructor = Util.getConstructor(clazz, String.class, String.class, String.class, Integer.TYPE);
        constructorNoArgs = constructor != null ? null : Util.getConstructor(clazz, new Class[0]);
        if (constructorNoArgs != null) {
            hashAlgField = Util.getField(clazz, "hashAlg");
            mgfField = Util.getField(clazz, "mgf");
            sLenField = Util.getField(clazz, "sLen");
        } else {
            hashAlgField = null;
            mgfField = null;
            sLenField = null;
        }
    }
}

