/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;
import iaik.pkcs.pkcs11.parameters.TLS12KeyMaterialParameters;
import iaik.pkcs.pkcs11.parameters.TLSMasterKeyDeriveParameters;
import iaik.pkcs.pkcs11.parameters.VersionParameters;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_VERSION;

public class TLS12MasterKeyDeriveParameters
extends TLSMasterKeyDeriveParameters {
    public static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS";
    private static final Constructor<?> constructor;
    private static final Field field_pVersion;
    public long prfHashMechanism;

    public static CK_VERSION getPVersion(Object object) {
        if (field_pVersion == null) {
            throw new IllegalStateException("field pVersion does not exist");
        }
        try {
            return (CK_VERSION)field_pVersion.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalStateException("could not get pVersion", ex);
        }
    }

    public TLS12MasterKeyDeriveParameters(SSL3RandomDataParameters random, VersionParameters version, long prfHashMechanism) {
        super(random, version);
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS is not available in the JDK");
        }
        this.prfHashMechanism = prfHashMechanism;
    }

    @Override
    public String toString() {
        return Util.concatObjects(super.toString(), "\nprfHashMechanism: ", this.prfHashMechanism);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof TLS12KeyMaterialParameters)) {
            return false;
        }
        TLS12KeyMaterialParameters other = (TLS12KeyMaterialParameters)otherObject;
        return this.prfHashMechanism == other.prfHashMechanism;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.prfHashMechanism;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        try {
            return constructor.newInstance(this.randomInfo == null ? null : this.randomInfo.getPKCS11ParamsObject(), this.version == null ? null : this.version.getPKCS11ParamsObject(), this.prfHashMechanism);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS", ex);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName(CLASS_CK_PARAMS, false, Parameters.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            clazz = null;
        }
        if (clazz != null) {
            constructor = Util.getConstructor(clazz, CK_SSL3_RANDOM_DATA.class, CK_VERSION.class, Long.TYPE);
            field_pVersion = Util.getField(clazz, "pVersion");
        } else {
            constructor = null;
            field_pVersion = null;
        }
    }
}

