/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialOutParameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;

public abstract class TLSKeyMaterialParameters
implements Parameters {
    protected long macSizeInBits;
    protected long keySizeInBits;
    protected long ivSizeInBits;
    protected boolean export;
    protected SSL3RandomDataParameters randomInfo;
    protected SSL3KeyMaterialOutParameters returnedKeyMaterial;

    public TLSKeyMaterialParameters(long macSizeInBits, long keySizeInBits, long ivSizeInBits, boolean export, SSL3RandomDataParameters randomInfo, SSL3KeyMaterialOutParameters returnedKeyMaterial) {
        this.macSizeInBits = macSizeInBits;
        this.keySizeInBits = keySizeInBits;
        this.ivSizeInBits = ivSizeInBits;
        this.export = export;
        this.randomInfo = Util.requireNonNull("randomInfo", randomInfo);
        this.returnedKeyMaterial = Util.requireNonNull("returnedKeyMaterial", returnedKeyMaterial);
    }

    public long getMacSizeInBits() {
        return this.macSizeInBits;
    }

    public long getKeySizeInBits() {
        return this.keySizeInBits;
    }

    public long getIVSizeInBits() {
        return this.ivSizeInBits;
    }

    public boolean isExport() {
        return this.export;
    }

    public SSL3RandomDataParameters getRandomInfo() {
        return this.randomInfo;
    }

    public SSL3KeyMaterialOutParameters getReturnedKeyMaterial() {
        return this.returnedKeyMaterial;
    }

    public void setMacSizeInBits(long macSizeInBits) {
        this.macSizeInBits = macSizeInBits;
    }

    public void setKeySizeInBits(long keySizeInBits) {
        this.keySizeInBits = keySizeInBits;
    }

    public void setIVSizeInBits(long ivSizeInBits) {
        this.ivSizeInBits = ivSizeInBits;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public void setRandomInfo(SSL3RandomDataParameters randomInfo) {
        this.randomInfo = Util.requireNonNull("randomInfo", randomInfo);
    }

    public void setReturnedKeyMaterial(SSL3KeyMaterialOutParameters returnedKeyMaterial) {
        this.returnedKeyMaterial = Util.requireNonNull("returnedKeyMaterial", returnedKeyMaterial);
    }

    public String toString() {
        return Util.concatObjects("  MAC Size in Bits (dec): ", this.macSizeInBits, "\n  Key Size in Bits (dec): ", this.keySizeInBits, "\n  IV Size in Bits (dec): ", this.ivSizeInBits, "\n  For Export Version: ", this.export, "\n  Client's and Server'S Random Information (hex):\n", this.randomInfo, "\n  Handles of the generated Keys and IVs: ", this.returnedKeyMaterial);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof TLSKeyMaterialParameters)) {
            return false;
        }
        TLSKeyMaterialParameters other = (TLSKeyMaterialParameters)otherObject;
        return this.macSizeInBits == other.macSizeInBits && this.keySizeInBits == other.keySizeInBits && this.ivSizeInBits == other.ivSizeInBits && this.export == other.export && this.randomInfo.equals(other.randomInfo) && this.returnedKeyMaterial.equals(other.returnedKeyMaterial);
    }

    public int hashCode() {
        return (int)this.macSizeInBits ^ (int)this.keySizeInBits ^ (int)this.ivSizeInBits ^ this.randomInfo.hashCode() ^ this.returnedKeyMaterial.hashCode();
    }
}

