/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.wrapper;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class Functions
implements PKCS11Constants {
    private static final String CKM_CODE_PROPERTIES = "/iaik/pkcs/pkcs11/wrapper/ckm.properties";
    private static final String CKR_CODE_PROPERTIES = "/iaik/pkcs/pkcs11/wrapper/ckr.properties";
    private static boolean mechCodeNamesAvailable;
    private static Map<Long, String> mechNames;
    private static Map<String, Long> mechNameToCodes;
    private static final Map<Long, String> hashMechCodeToHashNames;
    private static boolean errorCodeNamesAvailable;
    private static Map<Long, String> errorCodeNames;
    private static final Map<Long, String> mgfNames;
    private static Set<Long> fullEncryptDecryptMechs;
    private static Set<Long> sglOpEncryptDecryptMechs;
    private static Set<Long> fullSignVerifyMechs;
    private static Set<Long> sglOpSignVerifyMechs;
    private static Set<Long> signVerifyRecoverMechs;
    private static Set<Long> digestMechs;
    private static Set<Long> keyGenMechs;
    private static Set<Long> keyPairGenMechs;
    private static Set<Long> wrapUnwrapMechs;
    private static Set<Long> keyDerivationMechs;

    public static String mechanismCodeToString(long mechCode) {
        String name;
        Functions.initMechanismMap();
        String string = name = mechCodeNamesAvailable ? mechNames.get(mechCode) : null;
        if (name == null) {
            name = "Unknown mechanism with code: 0x" + Functions.toFullHex(mechCode);
        }
        return name;
    }

    public static String getMechanismDescription(long mechCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%#010x", mechCode));
        String name = Functions.mechanismCodeToString(mechCode);
        sb.append(" (").append(name).append(")");
        return sb.toString();
    }

    public static long mechanismStringToCode(String mechName) {
        Functions.initMechanismMap();
        Long code = mechCodeNamesAvailable ? mechNameToCodes.get(mechName) : null;
        return code != null ? code : -1L;
    }

    public static String getMGFName(long id) {
        return mgfNames.get(id);
    }

    private static synchronized void initMechanismMap() {
        if (mechNames != null) {
            return;
        }
        HashMap<Long, String> codeNameMap = new HashMap<Long, String>();
        HashMap<String, Long> nameCodeMap = new HashMap<String, Long>();
        Properties props = new Properties();
        try {
            props.load(Functions.class.getResourceAsStream(CKM_CODE_PROPERTIES));
            for (String propName : props.stringPropertyNames()) {
                String mechNames = props.getProperty(propName);
                StringTokenizer tokens = new StringTokenizer(mechNames, ",");
                if (!tokens.hasMoreTokens()) {
                    System.out.println("No name defined for Mechanism code " + propName);
                }
                long code = propName.startsWith("0x") || propName.startsWith("0X") ? Long.parseLong(propName.substring(2), 16) : Long.parseLong(propName);
                String mainMechName = tokens.nextToken();
                codeNameMap.put(code, mainMechName);
                while (tokens.hasMoreTokens()) {
                    nameCodeMap.put(tokens.nextToken(), code);
                }
            }
            codeNameMap.put(0xFFFFF00CL, "CKM_VENDOR_ISO2_SM4_MAC");
            codeNameMap.put(0xFFFFF00BL, "CKM_VENDOR_ISO2_SM4_MAC_GENERAL");
            codeNameMap.put(0xFFFFF002L, "CKM_VENDOR_SM2");
            codeNameMap.put(0xFFFFF004L, "CKM_VENDOR_SM2_ENCRYPT");
            codeNameMap.put(0xFFFFF001L, "CKM_VENDOR_SM2_KEY_PAIR_GEN");
            codeNameMap.put(0xFFFFF003L, "CKM_VENDOR_SM2_SM3");
            codeNameMap.put(0xFFFFF005L, "CKM_VENDOR_SM3");
            codeNameMap.put(0xFFFFF008L, "CKM_VENDOR_SM4_CBC");
            codeNameMap.put(0xFFFFF007L, "CKM_VENDOR_SM4_ECB");
            codeNameMap.put(0xFFFFF00DL, "CKM_VENDOR_SM4_ECB_ENCRYPT_DATA");
            codeNameMap.put(0xFFFFF006L, "CKM_VENDOR_SM4_KEY_GEN");
            codeNameMap.put(0xFFFFF00AL, "CKM_VENDOR_SM4_MAC");
            codeNameMap.put(0xFFFFF009L, "CKM_VENDOR_SM4_MAC_GENERAL");
            Set codes = codeNameMap.keySet();
            for (Long code : codes) {
                nameCodeMap.put((String)codeNameMap.get(code), code);
            }
            mechNames = codeNameMap;
            mechNameToCodes = nameCodeMap;
            mechCodeNamesAvailable = true;
        }
        catch (Exception ex) {
            System.err.println("Could not read properties for code names: " + ex.getMessage());
        }
    }

    public static String errorCodeToString(long errorCode) {
        String name;
        Functions.initErrorCodeMap();
        String string = name = errorCodeNamesAvailable ? errorCodeNames.get(errorCode) : null;
        if (name == null) {
            name = "Unknown CKR with code: 0x" + Functions.toFullHex(errorCode);
        }
        return name;
    }

    private static synchronized void initErrorCodeMap() {
        if (errorCodeNames != null) {
            return;
        }
        HashMap<Long, String> codeNamMap = new HashMap<Long, String>();
        Properties props = new Properties();
        try {
            props.load(Functions.class.getResourceAsStream(CKR_CODE_PROPERTIES));
            for (String propName : props.stringPropertyNames()) {
                String errorName = props.getProperty(propName);
                long code = propName.startsWith("0x") || propName.startsWith("0X") ? Long.parseLong(propName.substring(2), 16) : Long.parseLong(propName);
                codeNamMap.put(code, errorName);
            }
            errorCodeNames = codeNamMap;
            errorCodeNamesAvailable = true;
        }
        catch (Exception ex) {
            System.err.println("Could not read properties for error code names: " + ex.getMessage());
        }
    }

    private static Set<Long> asSet(long[] elements) {
        HashSet<Long> set = new HashSet<Long>();
        for (long el : elements) {
            set.add(el);
        }
        return set;
    }

    public static boolean isFullEncryptDecryptMechanism(long mechCode) {
        if (fullEncryptDecryptMechs == null) {
            long[] mechs = new long[]{4225L, 4226L, 4229L, 8452L, 8453L, 8454L, 8455L, 8456L, 4209L, 4230L, 4233L, 4231L, 4232L, 8457L, 8458L, 8459L, 306L, 307L, 310L, 336L, 337L, 338L, 339L, 4241L, 4244L, 1361L, 1362L, 1365L, 1377L, 1378L, 1381L, 1621L, 4641L, 4642L, 4646L, 16416L, 16417L, 16418L, 16423L, 16424L, 0xFFFFF008L, 0xFFFFF007L};
            fullEncryptDecryptMechs = Functions.asSet(mechs);
        }
        return fullEncryptDecryptMechs.contains(mechCode);
    }

    public static boolean isSingleOperationEncryptDecryptMechanism(long mechCode) {
        if (sglOpEncryptDecryptMechs == null) {
            long[] mechs = new long[]{1L, 9L, 3L, 16385L, 16386L};
            sglOpEncryptDecryptMechs = Functions.asSet(mechs);
        }
        return sglOpEncryptDecryptMechs.contains(mechCode);
    }

    public static boolean isFullSignVerifyMechanism(long mechCode) {
        if (fullSignVerifyMechs == null) {
            long[] mechs = new long[]{6L, 64L, 65L, 66L, 14L, 67L, 68L, 69L, 12L, 18L, 19L, 20L, 21L, 22L, 4162L, 4228L, 4227L, 4236L, 4237L, 4238L, 4235L, 4234L, 309L, 308L, 311L, 312L, 546L, 545L, 598L, 599L, 70L, 71L, 594L, 593L, 610L, 609L, 626L, 625L, 74L, 73L, 78L, 77L, 82L, 81L, 896L, 897L, 982L, 983L, 984L, 1280L, 1364L, 1363L, 1380L, 1379L, 642L, 657L, 672L, 1298L, 4643L, 4625L, 4610L, 4648L, 24L, 25L, 26L, 27L, 102L, 96L, 97L, 98L, 103L, 99L, 100L, 101L, 694L, 695L, 689L, 690L, 705L, 706L, 721L, 722L, 4167L, 4168L, 4169L, 4170L, 514L, 513L, 530L, 529L, 562L, 561L, 578L, 577L, 7L, 8L, 0xFFFFF002L, 0xFFFFF003L, 0xFFFFF009L, 0xFFFFF00AL, 0xFFFFF00BL, 0xFFFFF00CL, 16397L, 16398L, 16402L, 16403L, 16407L, 16408L, 16412L, 16413L, 16425L, 4183L, 0xFFFFF002L, 0xFFFFF003L, 0xFFFFF00CL, 0xFFFFF00AL, 0xFFFFF009L, 0xFFFFF00CL, 0xFFFFF00BL};
            fullSignVerifyMechs = Functions.asSet(mechs);
        }
        return fullSignVerifyMechs.contains(mechCode);
    }

    public static boolean isSingleOperationSignVerifyMechanism(long mechCode) {
        if (sglOpSignVerifyMechs == null) {
            long[] mechs = new long[]{1L, 13L, 2L, 3L, 11L, 17L, 4161L, 4609L};
            sglOpSignVerifyMechs = Functions.asSet(mechs);
        }
        return sglOpSignVerifyMechs.contains(mechCode);
    }

    public static boolean isSignVerifyRecoverMechanism(long mechCode) {
        if (signVerifyRecoverMechs == null) {
            long[] mechs = new long[]{1L, 2L, 3L, 1280L, 1617L, 1618L, 1620L};
            signVerifyRecoverMechs = Functions.asSet(mechs);
        }
        return signVerifyRecoverMechs.contains(mechCode);
    }

    public static boolean isDigestMechanism(long mechCode) {
        if (digestMechs == null) {
            long[] mechs = new long[]{544L, 597L, 592L, 608L, 624L, 72L, 76L, 80L, 1619L, 4624L, 693L, 688L, 704L, 720L, 512L, 528L, 560L, 576L, 0xFFFFF005L, 16396L, 16401L, 16406L, 16411L, 0xFFFFF005L};
            digestMechs = Functions.asSet(mechs);
        }
        return digestMechs.contains(mechCode);
    }

    public static boolean isKeyGenerationMechanism(long mechCode) {
        if (keyGenMechs == null) {
            long[] mechs = new long[]{8192L, 8195L, 8196L, 8193L, 848L, 4224L, 4210L, 304L, 305L, 936L, 937L, 960L, 944L, 880L, 976L, 1360L, 1376L, 1616L, 640L, 656L, 673L, 4640L, 4645L, 4647L, 0xFFFFF006L, 16387L, 16388L, 16389L, 16390L, 16391L, 16392L, 16393L, 16394L, 16400L, 16405L, 16410L, 16415L, 16428L, 0xFFFFF006L};
            keyGenMechs = Functions.asSet(mechs);
        }
        return keyGenMechs.contains(mechCode);
    }

    public static boolean isKeyPairGenerationMechanism(long mechCode) {
        if (keyPairGenMechs == null) {
            long[] mechs = new long[]{0L, 10L, 16L, 4160L, 32L, 48L, 4608L, 0xFFFFF001L, 4181L, 4182L, 0xFFFFF001L};
            keyPairGenMechs = Functions.asSet(mechs);
        }
        return keyPairGenMechs.contains(mechCode);
    }

    public static boolean isWrapUnwrapMechanism(long mechCode) {
        if (wrapUnwrapMechs == null) {
            long[] mechs = new long[]{1L, 9L, 3L, 16385L, 16386L, 4179L, 4225L, 4226L, 4229L, 8452L, 8453L, 8454L, 8455L, 8456L, 4209L, 4230L, 4233L, 4231L, 4232L, 8457L, 8458L, 8459L, 306L, 307L, 310L, 4241L, 4244L, 1361L, 1362L, 1365L, 1377L, 1378L, 1381L, 1621L, 1297L, 4641L, 4642L, 4644L, 4611L, 4646L, 0xFFFFF004L, 0xFFFFF007L, 0xFFFFF008L, 16416L, 16423L, 16424L, 0xFFFFF004L, 0xFFFFF007L};
            wrapUnwrapMechs = Functions.asSet(mechs);
        }
        return wrapUnwrapMechs.contains(mechCode);
    }

    public static boolean isKeyDerivationMechanism(long mechCode) {
        if (keyDerivationMechs == null) {
            long[] mechs = new long[]{4176L, 4177L, 4178L, 33L, 49L, 50L, 51L, 4238L, 4352L, 4353L, 4354L, 4355L, 4356L, 4357L, 914L, 918L, 915L, 916L, 917L, 75L, 79L, 83L, 881L, 883L, 882L, 992L, 994L, 993L, 995L, 997L, 977L, 978L, 980L, 981L, 979L, 864L, 866L, 867L, 868L, 869L, 1366L, 1367L, 1382L, 1383L, 1622L, 1623L, 1296L, 4612L, 920L, 919L, 921L, 922L, 923L, 924L, 915L, 915L, 915L, 915L, 0xFFFFF00DL, 16399L, 16404L, 16409L, 16414L, 16419L, 16420L, 16421L, 16422L, 940L, 941L, 942L, 16426L, 16427L, 0xFFFFF00DL};
            keyDerivationMechs = Functions.asSet(mechs);
        }
        return keyDerivationMechs.contains(mechCode);
    }

    public static String toFullHex(long value) {
        long currentValue = value;
        StringBuilder stringBuffer = new StringBuilder(16);
        for (int j = 0; j < 16; ++j) {
            int currentDigit = (int)currentValue & 0xF;
            stringBuffer.append(Hex.DIGITS[currentDigit]);
            currentValue >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHexString(byte[] value) {
        return Hex.encode(value);
    }

    public static byte[] decodeHex(String encoded) {
        return Hex.decode(encoded);
    }

    public static String getHashAlgName(Mechanism hashMechanism) {
        return Functions.getHashAlgName(hashMechanism.getMechanismCode());
    }

    public static String getHashAlgName(long hashMechanism) {
        return hashMechCodeToHashNames.get(hashMechanism);
    }

    static {
        mgfNames = new HashMap<Long, String>();
        hashMechCodeToHashNames = new HashMap<Long, String>();
        hashMechCodeToHashNames.put(544L, "SHA1");
        hashMechCodeToHashNames.put(597L, "SHA224");
        hashMechCodeToHashNames.put(592L, "SHA256");
        hashMechCodeToHashNames.put(608L, "SHA384");
        hashMechCodeToHashNames.put(624L, "SHA512");
        hashMechCodeToHashNames.put(72L, "SHA512/224");
        hashMechCodeToHashNames.put(76L, "SHA512/256");
        hashMechCodeToHashNames.put(693L, "SHA3-224");
        hashMechCodeToHashNames.put(688L, "SHA3-256");
        hashMechCodeToHashNames.put(704L, "SHA3-384");
        hashMechCodeToHashNames.put(720L, "SHA3-512");
        mgfNames.put(1L, "CKG_MGF1_SHA1");
        mgfNames.put(2L, "CKG_MGF1_SHA256");
        mgfNames.put(3L, "CKG_MGF1_SHA384");
        mgfNames.put(4L, "CKG_MGF1_SHA512");
        mgfNames.put(5L, "CKG_MGF1_SHA224");
        mgfNames.put(6L, "CKG_MGF1_SHA3-224");
        mgfNames.put(7L, "CKG_MGF1_SHA3-256");
        mgfNames.put(8L, "CKG_MGF1_SHA3-384");
        mgfNames.put(9L, "CKG_MGF1_SHA3-512");
    }

    private static class Hex {
        private static final char[] DIGITS;
        private static final char[] UPPER_DIGITS;
        private static final int[] LINTS;
        private static final int[] HINTS;

        private Hex() {
        }

        public static String encode(byte[] bytes) {
            return new String(Hex.encodeToChars(bytes));
        }

        public static char[] encodeToChars(byte[] data) {
            int len = data.length;
            char[] out = new char[len << 1];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
                out[j++] = DIGITS[0xF & data[i]];
            }
            return out;
        }

        public static byte[] decode(String hex) {
            char[] data = hex.toCharArray();
            int len = data.length;
            if ((len & 1) != 0) {
                throw new IllegalArgumentException("Odd number of characters.");
            }
            byte[] out = new byte[len >> 1];
            int i = 0;
            int j = 0;
            while (j < len) {
                out[i] = (byte)(HINTS[data[j++]] | LINTS[data[j++]]);
                ++i;
            }
            return out;
        }

        static {
            int i;
            DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            UPPER_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            LINTS = new int[103];
            HINTS = new int[LINTS.length];
            for (i = 0; i < DIGITS.length; ++i) {
                Hex.LINTS[Hex.DIGITS[i]] = i;
            }
            for (i = 10; i < UPPER_DIGITS.length; ++i) {
                Hex.LINTS[Hex.UPPER_DIGITS[i]] = i;
            }
            for (i = 0; i < LINTS.length; ++i) {
                Hex.HINTS[i] = LINTS[i] << 4;
            }
        }
    }
}

