/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import org.xipki.password.OBFPasswordService;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SinglePasswordResolver;

public class OBFSinglePasswordResolver
implements SinglePasswordResolver {
    @Override
    public boolean canResolveProtocol(String protocol) {
        return "OBF".equalsIgnoreCase(protocol);
    }

    @Override
    public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
        return OBFPasswordService.deobfuscate(passwordHint).toCharArray();
    }

    @Override
    public String protectPassword(char[] password) throws PasswordResolverException {
        return OBFPasswordService.obfuscate(new String(password));
    }
}

