/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import org.xipki.password.PBEAlgo;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.password.callback.FilePasswordCallback;
import org.xipki.password.callback.GuiPasswordCallback;
import org.xipki.password.callback.OBFPasswordCallback;
import org.xipki.password.callback.PBEConsumerPasswordCallback;
import org.xipki.password.callback.PBEGuiPasswordCallback;
import org.xipki.password.callback.PasswordCallback;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class PBESinglePasswordResolver
implements SinglePasswordResolver {
    private char[] masterPassword;
    private final Object masterPasswordLock = new Object();
    private String masterPasswordCallback = "PBE-GUI";
    private PasswordCallback masterPwdCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getMasterPassword(String encryptedPassword) throws PasswordResolverException {
        Object object = this.masterPasswordLock;
        synchronized (object) {
            this.init();
            if (this.masterPassword == null) {
                if (this.masterPwdCallback == null) {
                    throw new PasswordResolverException("masterPasswordCallback is not initialized");
                }
                this.masterPassword = this.masterPwdCallback.getPassword("Please enter the master password", encryptedPassword);
            }
            return this.masterPassword;
        }
    }

    private void init() {
        PasswordCallback pwdCallback;
        String type;
        if (this.masterPwdCallback != null) {
            return;
        }
        if (StringUtil.isBlank((String)this.masterPasswordCallback)) {
            return;
        }
        String conf = null;
        int delimIndex = this.masterPasswordCallback.indexOf(32);
        if (delimIndex == -1) {
            type = this.masterPasswordCallback;
        } else {
            type = this.masterPasswordCallback.substring(0, delimIndex);
            conf = this.masterPasswordCallback.substring(delimIndex + 1);
        }
        if ("FILE".equalsIgnoreCase(type)) {
            pwdCallback = new FilePasswordCallback();
        } else if ("GUI".equalsIgnoreCase(type)) {
            pwdCallback = new GuiPasswordCallback();
        } else if ("PBE-GUI".equalsIgnoreCase(type)) {
            pwdCallback = new PBEGuiPasswordCallback();
        } else if ("PBE-Consumer".equalsIgnoreCase(type)) {
            pwdCallback = new PBEConsumerPasswordCallback();
        } else if ("OBF".equalsIgnoreCase(type)) {
            pwdCallback = new OBFPasswordCallback();
            if (conf != null && !StringUtil.startsWithIgnoreCase((String)conf, (String)"OBF:")) {
                conf = "OBF:" + conf;
            }
        } else {
            throw new RuntimeException("unknown PasswordCallback type '" + type + "'");
        }
        try {
            pwdCallback.init(conf);
        }
        catch (PasswordResolverException ex) {
            throw new IllegalArgumentException("invalid masterPasswordCallback configuration " + this.masterPasswordCallback + ", " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        this.masterPwdCallback = pwdCallback;
    }

    public void clearMasterPassword() {
        this.masterPassword = null;
    }

    @Override
    public boolean canResolveProtocol(String protocol) {
        return "PBE".equalsIgnoreCase(protocol);
    }

    @Override
    public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
        return PBEPasswordService.decryptPassword(this.getMasterPassword(passwordHint), passwordHint);
    }

    @Override
    public String protectPassword(char[] password) throws PasswordResolverException {
        int iterationCount = 2000;
        return PBEPasswordService.encryptPassword(PBEAlgo.PBEWithHmacSHA256AndAES_256, 2000, this.getMasterPassword(null), password);
    }

    public void setMasterPasswordCallback(String masterPasswordCallback) {
        ParamUtil.requireNonBlank((String)"masterPasswordCallback", (String)masterPasswordCallback);
        this.masterPasswordCallback = masterPasswordCallback.trim();
    }
}

