/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.OBFSinglePasswordResolver;
import org.xipki.password.PBESinglePasswordResolver;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SinglePasswordResolver;

public class PasswordResolverImpl
implements PasswordResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordResolverImpl.class);
    private ConcurrentLinkedQueue<SinglePasswordResolver> resolvers = new ConcurrentLinkedQueue();
    private boolean initialized = false;
    private String masterPasswordCallback;

    public void init() {
        if (this.initialized) {
            return;
        }
        this.resolvers.add(new OBFSinglePasswordResolver());
        PBESinglePasswordResolver pbe = new PBESinglePasswordResolver();
        if (this.masterPasswordCallback != null) {
            pbe.setMasterPasswordCallback(this.masterPasswordCallback);
        }
        this.resolvers.add(pbe);
        this.initialized = true;
    }

    public void bindService(SinglePasswordResolver service) {
        if (service == null) {
            LOG.debug("bindService invoked with null.");
            return;
        }
        boolean replaced = this.resolvers.remove(service);
        this.resolvers.add(service);
        String txt = replaced ? "replaced" : "added";
        LOG.debug("{} SinglePasswordResolver binding for {}", (Object)txt, (Object)service);
    }

    public void unbindService(SinglePasswordResolver service) {
        if (service == null) {
            LOG.debug("unbindService invoked with null.");
            return;
        }
        try {
            if (this.resolvers.remove(service)) {
                LOG.debug("removed SinglePasswordResolver binding for {}", (Object)service);
            } else {
                LOG.debug("no SinglePasswordResolver binding found to remove for '{}'", (Object)service);
            }
        }
        catch (Exception ex) {
            LOG.debug("caught Exception({}). service is probably destroyed.", (Object)ex.getMessage());
        }
    }

    @Override
    public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
        Objects.requireNonNull(passwordHint, "passwordHint must not be null");
        int index = passwordHint.indexOf(58);
        if (index == -1) {
            return passwordHint.toCharArray();
        }
        String protocol = passwordHint.substring(0, index);
        for (SinglePasswordResolver resolver : this.resolvers) {
            if (!resolver.canResolveProtocol(protocol)) continue;
            return resolver.resolvePassword(passwordHint);
        }
        throw new PasswordResolverException("could not find password resolver to resolve password of protocol '" + protocol + "'");
    }

    @Override
    public String protectPassword(String protocol, char[] password) throws PasswordResolverException {
        Objects.requireNonNull(protocol, "protocol must not be null");
        Objects.requireNonNull(password, "password must not be null");
        for (SinglePasswordResolver resolver : this.resolvers) {
            if (!resolver.canResolveProtocol(protocol)) continue;
            return resolver.protectPassword(password);
        }
        throw new PasswordResolverException("could not find password resolver to protect password of protocol '" + protocol + "'");
    }

    public void setMasterPasswordCallback(String masterPasswordCallback) {
        this.masterPasswordCallback = masterPasswordCallback;
    }
}

