/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.xipki.password.PBEAlgo;
import org.xipki.password.PasswordBasedEncryption;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.StringUtil;

public class PBEPasswordService {
    public static char[] decryptPassword(char[] masterPassword, String passwordHint) throws PasswordResolverException {
        byte[] pwd;
        int bb;
        int algoCode;
        PBEAlgo algo;
        Args.notNull((Object)masterPassword, (String)"masterPassword");
        Args.notNull((Object)passwordHint, (String)"passwordHint");
        byte[] bytes = Base64.decode((String)passwordHint.substring("PBE:".length()));
        int len = bytes.length;
        if (len <= 16 && len != 0) {
            throw new PasswordResolverException("invalid length of the encrypted password");
        }
        int offset = 0;
        if ((algo = PBEAlgo.forCode(algoCode = (bb = bytes[offset++]) < 0 ? 256 + bb : bb)) == null) {
            throw new PasswordResolverException("unknown algorithm code " + algoCode);
        }
        byte[] iterationCountBytes = Arrays.copyOfRange(bytes, offset, offset + 2);
        byte[] salt = Arrays.copyOfRange(bytes, offset += 2, offset + 16);
        byte[] cipherText = Arrays.copyOfRange(bytes, offset += 16, len);
        int iterationCount = new BigInteger(1, iterationCountBytes).intValue();
        try {
            pwd = PasswordBasedEncryption.decrypt(algo, cipherText, masterPassword, iterationCount, salt);
        }
        catch (GeneralSecurityException ex) {
            throw new PasswordResolverException("could not decrypt the password: " + ex.getMessage());
        }
        char[] ret = new char[pwd.length];
        for (int i = 0; i < pwd.length; ++i) {
            ret[i] = (char)pwd[i];
        }
        return ret;
    }

    public static String encryptPassword(PBEAlgo algo, int iterationCount, char[] masterPassword, char[] password) throws PasswordResolverException {
        byte[] encrypted;
        Args.range((int)iterationCount, (String)"iterationCount", (int)1, (int)65535);
        Args.notNull((Object)masterPassword, (String)"masterPassword");
        Args.notNull((Object)password, (String)"password");
        byte[] iterationCountBytes = new byte[]{(byte)(iterationCount >>> 8), (byte)(iterationCount & 0xFF)};
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        try {
            encrypted = PasswordBasedEncryption.encrypt(algo, StringUtil.toUtf8Bytes((String)new String(password)), masterPassword, iterationCount, salt);
        }
        catch (GeneralSecurityException ex) {
            throw new PasswordResolverException("could not encrypt the password: " + ex.getMessage());
        }
        byte[] encryptedText = new byte[3 + salt.length + encrypted.length];
        int offset = 0;
        encryptedText[offset++] = (byte)(algo.code() & 0xFF);
        System.arraycopy(iterationCountBytes, 0, encryptedText, offset, 2);
        System.arraycopy(salt, 0, encryptedText, offset += 2, salt.length);
        System.arraycopy(encrypted, 0, encryptedText, offset += salt.length, encrypted.length);
        return StringUtil.concat((String)"PBE:", (String[])new String[]{Base64.encodeToString((byte[])encryptedText)});
    }
}

