/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.OBFPasswordService;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SecurePasswordInputPanel;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public interface PasswordCallback {
    public void init(String var1) throws PasswordResolverException;

    public char[] getPassword(String var1, String var2) throws PasswordResolverException;

    public static class PBEGui
    extends Gui {
        @Override
        protected boolean isPasswordValid(char[] password, String testToken) {
            if (StringUtil.isBlank((String)testToken)) {
                return true;
            }
            try {
                PBEPasswordService.decryptPassword(password, testToken);
                return true;
            }
            catch (PasswordResolverException ex) {
                return false;
            }
        }
    }

    public static class OBF
    implements PasswordCallback {
        private char[] password;

        @Override
        public char[] getPassword(String prompt, String testToken) throws PasswordResolverException {
            if (this.password == null) {
                throw new PasswordResolverException("please initialize me first");
            }
            return this.password;
        }

        @Override
        public void init(String conf) throws PasswordResolverException {
            Args.notBlank((String)conf, (String)"conf");
            this.password = OBFPasswordService.deobfuscate(conf).toCharArray();
        }
    }

    public static class Gui
    implements PasswordCallback {
        private int quorum = 1;
        private int tries = 3;

        protected boolean isPasswordValid(char[] password, String testToken) {
            return true;
        }

        @Override
        public char[] getPassword(String prompt, String testToken) throws PasswordResolverException {
            String tmpPrompt = prompt;
            if (StringUtil.isBlank((String)tmpPrompt)) {
                tmpPrompt = "Password required";
            }
            for (int i = 0; i < this.tries; ++i) {
                char[] password;
                if (this.quorum == 1) {
                    password = SecurePasswordInputPanel.readPassword(tmpPrompt);
                    if (password == null) {
                        throw new PasswordResolverException("user has cancelled");
                    }
                } else {
                    char[][] passwordParts = new char[this.quorum][];
                    for (int j = 0; j < this.quorum; ++j) {
                        String promptPart = tmpPrompt + " (part " + (j + 1) + "/" + this.quorum + ")";
                        passwordParts[j] = SecurePasswordInputPanel.readPassword(promptPart);
                        if (passwordParts[j] != null) continue;
                        throw new PasswordResolverException("user has cancelled");
                    }
                    password = StringUtil.merge((char[][])passwordParts);
                }
                if (!this.isPasswordValid(password, testToken)) continue;
                return password;
            }
            throw new PasswordResolverException("Could not get the password after " + this.tries + " tries");
        }

        @Override
        public void init(String conf) throws PasswordResolverException {
            int intValue;
            if (StringUtil.isBlank((String)conf)) {
                this.quorum = 1;
                return;
            }
            ConfPairs pairs = new ConfPairs(conf);
            String str = pairs.value("quorum");
            this.quorum = Integer.valueOf(str);
            if (this.quorum < 1 || this.quorum > 10) {
                throw new PasswordResolverException("quorum " + this.quorum + " is not in [1,10]");
            }
            str = pairs.value("tries");
            if (StringUtil.isNotBlank((String)str) && (intValue = Integer.parseInt(str)) > 0) {
                this.tries = intValue;
            }
        }
    }

    public static class File
    implements PasswordCallback {
        private static final Logger LOG = LoggerFactory.getLogger(File.class);
        private String passwordFile;

        @Override
        public char[] getPassword(String prompt, String testToken) throws PasswordResolverException {
            if (this.passwordFile == null) {
                throw new PasswordResolverException("please initialize me first");
            }
            String passwordHint = null;
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(Paths.get(IoUtil.expandFilepath((String)this.passwordFile), new String[0]));
                while ((line = reader.readLine()) != null) {
                    if (!StringUtil.isNotBlank((String)(line = line.trim())) || line.startsWith("#")) continue;
                    passwordHint = line;
                    break;
                }
            }
            catch (IOException ex) {
                throw new PasswordResolverException("could not read file " + this.passwordFile, ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        LOG.error("could not close reader: {}", (Object)ex.getMessage());
                    }
                }
            }
            if (passwordHint == null) {
                throw new PasswordResolverException("no password is specified in file " + this.passwordFile);
            }
            if (StringUtil.startsWithIgnoreCase(passwordHint, (String)"OBF:")) {
                return OBFPasswordService.deobfuscate(passwordHint).toCharArray();
            }
            return passwordHint.toCharArray();
        }

        @Override
        public void init(String conf) throws PasswordResolverException {
            Args.notBlank((String)conf, (String)"conf");
            ConfPairs pairs = new ConfPairs(conf);
            this.passwordFile = pairs.value("file");
            if (StringUtil.isBlank((String)this.passwordFile)) {
                throw new PasswordResolverException("invalid configuration " + conf + ", no file is specified");
            }
            this.passwordFile = IoUtil.expandFilepath((String)this.passwordFile);
        }
    }
}

