/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.io.IOException;
import java.util.List;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverImpl;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.util.CollectionUtil;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidatableConf;

public class Passwords {
    private PasswordResolverImpl passwordResolver;

    public void init() throws IOException, InvalidConfException {
        this.init(null);
    }

    public void init(PasswordConf conf) throws IOException, InvalidConfException {
        this.passwordResolver = new PasswordResolverImpl();
        if (conf == null) {
            conf = PasswordConf.DEFAULT;
        }
        this.passwordResolver.setMasterPasswordCallback(conf.getMasterPasswordCallback());
        this.passwordResolver.init();
        List<String> singlePasswordResolvers = conf.getSinglePasswordResolvers();
        if (CollectionUtil.isNotEmpty(singlePasswordResolvers)) {
            for (String className : singlePasswordResolvers) {
                try {
                    Class<?> clazz = Class.forName(className);
                    SinglePasswordResolver resolver = (SinglePasswordResolver)clazz.newInstance();
                    this.passwordResolver.registResolver(resolver);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new InvalidConfException("error caught while initializing SinglePasswordResolver " + className + ": " + ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public PasswordResolver getPasswordResolver() {
        return this.passwordResolver;
    }

    public static class PasswordConf
    extends ValidatableConf {
        public static final String dflt_masterPasswordCallback = "PBE-GUI quorum=1,tries=3";
        private String masterPasswordCallback;
        public static final PasswordConf DEFAULT = new PasswordConf();
        private List<String> singlePasswordResolvers;

        public String getMasterPasswordCallback() {
            return StringUtil.isBlank((String)this.masterPasswordCallback) ? dflt_masterPasswordCallback : this.masterPasswordCallback;
        }

        public void setMasterPasswordCallback(String masterPasswordCallback) {
            this.masterPasswordCallback = masterPasswordCallback;
        }

        public List<String> getSinglePasswordResolvers() {
            return this.singlePasswordResolvers;
        }

        public void setSinglePasswordResolvers(List<String> singlePasswordResolvers) {
            this.singlePasswordResolvers = singlePasswordResolvers;
        }

        public void validate() throws InvalidConfException {
        }
    }
}

