/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.EOFException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.Base64;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.http.servlet.AbstractHttpServlet;
import org.xipki.http.servlet.ServletURI;
import org.xipki.http.servlet.SslReverseProxyMode;
import org.xipki.ocsp.server.impl.OcspRespWithCacheInfo;
import org.xipki.ocsp.server.impl.OcspServer;
import org.xipki.ocsp.server.impl.Responder;
import org.xipki.security.HashAlgoType;

public class HttpOcspServlet
extends AbstractHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpOcspServlet.class);
    private static final String CT_REQUEST = "application/ocsp-request";
    private static final String CT_RESPONSE = "application/ocsp-response";
    private OcspServer server;

    public void setServer(OcspServer server) {
        this.server = (OcspServer)ParamUtil.requireNonNull((String)"server", (Object)server);
    }

    public FullHttpResponse service(FullHttpRequest request, ServletURI servletUri, SSLSession sslSession, SslReverseProxyMode sslReverseProxyMode) throws Exception {
        if (this.server == null) {
            String message = "responder in servlet not configured";
            LOG.error(message);
            return HttpOcspServlet.createErrorResponse((HttpVersion)request.protocolVersion(), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        HttpMethod method = request.method();
        if (HttpMethod.POST.equals((Object)method)) {
            return this.servicePost(request, servletUri, sslSession, sslReverseProxyMode);
        }
        if (HttpMethod.GET.equals((Object)method)) {
            return this.serviceGet(request, servletUri, sslSession, sslReverseProxyMode);
        }
        return HttpOcspServlet.createErrorResponse((HttpVersion)request.protocolVersion(), (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    private FullHttpResponse servicePost(FullHttpRequest request, ServletURI servletUri, SSLSession sslSession, SslReverseProxyMode sslReverseProxyMode) throws Exception {
        HttpVersion version = request.protocolVersion();
        Responder responder = this.server.getResponder(servletUri);
        if (responder == null) {
            return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
        }
        try {
            String reqContentType = request.headers().get("Content-Type");
            if (!CT_REQUEST.equalsIgnoreCase(reqContentType)) {
                return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            int contentLen = request.content().readableBytes();
            if (contentLen > responder.requestOption().maxRequestSize()) {
                return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            }
            OcspRespWithCacheInfo ocspRespWithCacheInfo = this.server.answer(responder, HttpOcspServlet.readContent((FullHttpRequest)request), false);
            if (ocspRespWithCacheInfo == null || ocspRespWithCacheInfo.response() == null) {
                LOG.error("processRequest returned null, this should not happen");
                return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            byte[] encodedOcspResp = ocspRespWithCacheInfo.response();
            return HttpOcspServlet.createOKResponse((HttpVersion)version, (String)CT_RESPONSE, (byte[])encodedOcspResp);
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"Connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private FullHttpResponse serviceGet(FullHttpRequest request, ServletURI servletUri, SSLSession sslSession, SslReverseProxyMode sslReverseProxyMode) throws Exception {
        HttpVersion version = request.protocolVersion();
        Object[] objs = this.server.getServletPathAndResponder(servletUri);
        if (objs == null) {
            return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
        }
        String path = servletUri.path();
        String servletPath = (String)objs[0];
        Responder responder = (Responder)objs[1];
        if (!responder.requestOption().supportsHttpGet()) {
            return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
        int offset = servletPath.length();
        if (path.length() - offset > 10) {
            if (path.charAt(offset) == '/') {
                ++offset;
            }
        } else {
            return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST);
        }
        String b64OcspReq = servletUri.path().substring(offset);
        try {
            if (b64OcspReq.length() > responder.requestOption().maxRequestSize()) {
                return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            }
            OcspRespWithCacheInfo ocspRespWithCacheInfo = this.server.answer(responder, Base64.decode((String)b64OcspReq), true);
            if (ocspRespWithCacheInfo == null || ocspRespWithCacheInfo.response() == null) {
                return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            byte[] encodedOcspResp = ocspRespWithCacheInfo.response();
            FullHttpResponse response = HttpOcspServlet.createOKResponse((HttpVersion)version, (String)CT_RESPONSE, (byte[])encodedOcspResp);
            OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = ocspRespWithCacheInfo.cacheInfo();
            if (cacheInfo != null) {
                encodedOcspResp = ocspRespWithCacheInfo.response();
                long now = System.currentTimeMillis();
                HttpHeaders headers = response.headers();
                headers.add("Date", (Object)now);
                headers.add("Last-Modified", (Object)cacheInfo.thisUpdate());
                if (cacheInfo.nextUpdate() != null) {
                    headers.add("Expires", (Object)cacheInfo.nextUpdate());
                }
                headers.add("ETag", (Object)new StringBuilder(42).append('\\').append(HashAlgoType.SHA1.hexHash(encodedOcspResp)).append('\\').toString());
                long maxAge = responder.responseOption().cacheMaxAge() != null ? responder.responseOption().cacheMaxAge() : 60L;
                if (cacheInfo.nextUpdate() != null) {
                    maxAge = Math.min(maxAge, (cacheInfo.nextUpdate() - cacheInfo.thisUpdate()) / 1000L);
                }
                headers.add("Cache-Control", (Object)new StringBuilder(55).append("max-age=").append(maxAge).append(",public,no-transform,must-revalidate").toString());
            }
            return response;
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"Connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            return HttpOcspServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

