/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.ASN1Type;
import org.xipki.ocsp.server.impl.type.CertID;
import org.xipki.ocsp.server.impl.type.Extensions;
import org.xipki.ocsp.server.impl.type.ResponderID;
import org.xipki.ocsp.server.impl.type.ResponseData;
import org.xipki.ocsp.server.impl.type.SingleResponse;
import org.xipki.ocsp.server.impl.type.TaggedCertSequence;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.NoIdleSignerException;

public class OCSPRespBuilder {
    private static final byte[] successfulStatus = Hex.decode((String)"0a0100");
    private static final byte[] responseTypeBasic = Hex.decode((String)"06092b0601050507300101");
    private List<SingleResponse> list = new LinkedList<SingleResponse>();
    private Extensions responseExtensions = null;
    private ResponderID responderId;

    public OCSPRespBuilder(ResponderID responderId) {
        this.responderId = responderId;
    }

    public void addResponse(CertID certId, byte[] certStatus, Date thisUpdate, Date nextUpdate, Extensions singleExtensions) {
        this.list.add(new SingleResponse(certId, certStatus, thisUpdate, nextUpdate, singleExtensions));
    }

    public void setResponseExtensions(Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] buildOCSPResponse(ConcurrentContentSigner signer, TaggedCertSequence taggedCertSequence, Date producedAt) throws OCSPException, NoIdleSignerException {
        byte[] sigAlgId;
        byte[] signature;
        ResponseData responseData = new ResponseData(0, this.responderId, producedAt, this.list, this.responseExtensions);
        byte[] tbs = new byte[responseData.encodedLength()];
        responseData.write(tbs, 0);
        ConcurrentBagEntrySigner signer0 = signer.borrowContentSigner();
        try {
            XiContentSigner csigner0 = (XiContentSigner)signer0.value();
            OutputStream sigOut = csigner0.getOutputStream();
            try {
                sigOut.write(tbs);
                sigOut.close();
            }
            catch (IOException ex) {
                throw new OCSPException("exception signing TBSRequest: " + ex.getMessage(), (Throwable)ex);
            }
            signature = csigner0.getSignature();
            sigAlgId = csigner0.getEncodedAlgorithmIdentifier();
        }
        finally {
            signer.requiteContentSigner(signer0);
        }
        int signatureBodyLen = signature.length + 1;
        int signatureLen = OCSPRespBuilder.getLen(signatureBodyLen);
        int basicResponseBodyLen = tbs.length + sigAlgId.length + signatureLen;
        if (taggedCertSequence != null) {
            basicResponseBodyLen += taggedCertSequence.encodedLength();
        }
        int basicResponseLen = OCSPRespBuilder.getLen(basicResponseBodyLen);
        int responseBytesBodyLen = responseTypeBasic.length + OCSPRespBuilder.getLen(basicResponseLen);
        int responseBytesLen = OCSPRespBuilder.getLen(responseBytesBodyLen);
        int taggedResponseBytesLen = OCSPRespBuilder.getLen(responseBytesLen);
        int ocspResponseBodyLen = successfulStatus.length + taggedResponseBytesLen;
        int ocspResponseLen = OCSPRespBuilder.getLen(ocspResponseBodyLen);
        byte[] out = new byte[ocspResponseLen];
        int offset = 0;
        offset += ASN1Type.writeHeader((byte)48, (int)ocspResponseBodyLen, (byte[])out, (int)offset);
        offset += OCSPRespBuilder.arraycopy(successfulStatus, out, offset);
        offset += ASN1Type.writeHeader((byte)-96, (int)responseBytesLen, (byte[])out, (int)offset);
        offset += ASN1Type.writeHeader((byte)48, (int)responseBytesBodyLen, (byte[])out, (int)offset);
        offset += OCSPRespBuilder.arraycopy(responseTypeBasic, out, offset);
        offset += ASN1Type.writeHeader((byte)4, (int)basicResponseLen, (byte[])out, (int)offset);
        offset += ASN1Type.writeHeader((byte)48, (int)basicResponseBodyLen, (byte[])out, (int)offset);
        offset += OCSPRespBuilder.arraycopy(tbs, out, offset);
        offset += OCSPRespBuilder.arraycopy(sigAlgId, out, offset);
        offset += ASN1Type.writeHeader((byte)3, (int)signatureBodyLen, (byte[])out, (int)offset);
        out[offset++] = 0;
        offset += OCSPRespBuilder.arraycopy(signature, out, offset);
        if (taggedCertSequence != null) {
            offset += taggedCertSequence.write(out, offset);
        }
        return out;
    }

    private static int getLen(int bodyLen) {
        return ASN1Type.getHeaderLen((int)bodyLen) + bodyLen;
    }

    private static int arraycopy(byte[] src, byte[] dest, int destPos) {
        System.arraycopy(src, 0, dest, destPos, src.length);
        return src.length;
    }
}

