/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.xipki.common.InvalidConfException;
import org.xipki.common.TripleState;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.server.impl.CertWithEncoded;
import org.xipki.ocsp.server.impl.jaxb.CertCollectionType;
import org.xipki.ocsp.server.impl.jaxb.NonceType;
import org.xipki.ocsp.server.impl.jaxb.RequestOptionType;
import org.xipki.ocsp.server.impl.jaxb.VersionsType;
import org.xipki.security.CertpathValidationModel;
import org.xipki.security.HashAlgoType;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;

class RequestOption {
    static final Set<HashAlgoType> SUPPORTED_HASH_ALGORITHMS = new HashSet<HashAlgoType>();
    private final boolean supportsHttpGet;
    private final boolean signatureRequired;
    private final boolean validateSignature;
    private final int maxRequestListCount;
    private final int maxRequestSize;
    private final Collection<Integer> versions;
    private final TripleState nonceOccurrence;
    private final int nonceMinLen;
    private final int nonceMaxLen;
    private final Set<HashAlgoType> hashAlgos;
    private final Set<CertWithEncoded> trustAnchors;
    private final Set<X509Certificate> certs;
    private final CertpathValidationModel certpathValidationModel;

    RequestOption(RequestOptionType conf) throws InvalidConfException {
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        this.supportsHttpGet = conf.isSupportsHttpGet();
        this.signatureRequired = conf.isSignatureRequired();
        this.validateSignature = conf.isValidateSignature();
        NonceType nonceConf = conf.getNonce();
        int minLen = 4;
        int maxLen = 32;
        String str = nonceConf.getOccurrence().toLowerCase();
        if ("forbidden".equals(str)) {
            this.nonceOccurrence = TripleState.FORBIDDEN;
        } else if ("optional".equals(str)) {
            this.nonceOccurrence = TripleState.OPTIONAL;
        } else if ("required".equals(str)) {
            this.nonceOccurrence = TripleState.REQUIRED;
        } else {
            throw new InvalidConfException("invalid nonce.occurrence '" + str + "', only forbidded, optional, and required are allowed");
        }
        if (nonceConf.getMinLen() != null) {
            minLen = nonceConf.getMinLen();
        }
        if (nonceConf.getMaxLen() != null) {
            maxLen = nonceConf.getMaxLen();
        }
        this.maxRequestListCount = conf.getMaxRequestListCount();
        if (this.maxRequestListCount < 1) {
            throw new InvalidConfException("invalid maxRequestListCount " + this.maxRequestListCount);
        }
        this.maxRequestSize = conf.getMaxRequestSize();
        if (this.maxRequestSize < 100) {
            throw new InvalidConfException("invalid maxRequestSize " + this.maxRequestSize);
        }
        this.nonceMinLen = minLen;
        this.nonceMaxLen = maxLen;
        VersionsType versionsConf = conf.getVersions();
        this.versions = new HashSet<Integer>();
        for (String string : versionsConf.getVersion()) {
            if ("v1".equalsIgnoreCase(string)) {
                this.versions.add(0);
                continue;
            }
            throw new InvalidConfException("invalid OCSP request version '" + string + "'");
        }
        this.hashAlgos = new HashSet<HashAlgoType>();
        RequestOptionType.HashAlgorithms reqHashAlgosConf = conf.getHashAlgorithms();
        if (reqHashAlgosConf != null) {
            for (String token : reqHashAlgosConf.getAlgorithm()) {
                HashAlgoType algo = HashAlgoType.getHashAlgoType((String)token);
                if (algo != null && SUPPORTED_HASH_ALGORITHMS.contains(algo)) {
                    this.hashAlgos.add(algo);
                    continue;
                }
                throw new InvalidConfException("hash algorithm " + token + " is unsupported");
            }
        } else {
            this.hashAlgos.addAll(SUPPORTED_HASH_ALGORITHMS);
        }
        RequestOptionType.CertpathValidation certpathValidation = conf.getCertpathValidation();
        if (certpathValidation == null) {
            if (this.validateSignature) {
                throw new InvalidConfException("certpathValidation is not specified");
            }
            this.trustAnchors = null;
            this.certs = null;
            this.certpathValidationModel = CertpathValidationModel.PKIX;
            return;
        }
        switch (certpathValidation.getValidationModel()) {
            case CHAIN: {
                this.certpathValidationModel = CertpathValidationModel.CHAIN;
                break;
            }
            case PKIX: {
                this.certpathValidationModel = CertpathValidationModel.PKIX;
                break;
            }
            default: {
                throw new RuntimeException("should not reach here, unknown ValidationModel " + (Object)((Object)certpathValidation.getValidationModel()));
            }
        }
        try {
            Set<X509Certificate> tmpCerts = RequestOption.getCerts(certpathValidation.getTrustAnchors());
            this.trustAnchors = new HashSet<CertWithEncoded>(tmpCerts.size());
            for (X509Certificate m : tmpCerts) {
                this.trustAnchors.add(new CertWithEncoded(m));
            }
        }
        catch (Exception ex) {
            throw new InvalidConfException("could not initialize the trustAnchors: " + ex.getMessage(), (Throwable)ex);
        }
        CertCollectionType certsType = certpathValidation.getCerts();
        try {
            this.certs = certsType == null ? null : RequestOption.getCerts(certsType);
        }
        catch (Exception ex) {
            throw new InvalidConfException("could not initialize the certs: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Set<HashAlgoType> hashAlgos() {
        return this.hashAlgos;
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public boolean isValidateSignature() {
        return this.validateSignature;
    }

    public boolean supportsHttpGet() {
        return this.supportsHttpGet;
    }

    public TripleState nonceOccurrence() {
        return this.nonceOccurrence;
    }

    public int maxRequestListCount() {
        return this.maxRequestListCount;
    }

    public int maxRequestSize() {
        return this.maxRequestSize;
    }

    public int nonceMinLen() {
        return this.nonceMinLen;
    }

    public int nonceMaxLen() {
        return this.nonceMaxLen;
    }

    public boolean allows(HashAlgoType hashAlgo) {
        return hashAlgo == null ? false : this.hashAlgos.contains(hashAlgo);
    }

    public CertpathValidationModel certpathValidationModel() {
        return this.certpathValidationModel;
    }

    public Set<CertWithEncoded> trustAnchors() {
        return this.trustAnchors;
    }

    public Set<X509Certificate> certs() {
        return this.certs;
    }

    public boolean isVersionAllowed(Integer version) {
        return this.versions == null || this.versions.contains(version);
    }

    private static Set<X509Certificate> getCerts(CertCollectionType conf) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, IOException {
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        HashSet<X509Certificate> tmpCerts = new HashSet<X509Certificate>();
        if (conf.getKeystore() != null) {
            CertCollectionType.Keystore ksConf = conf.getKeystore();
            KeyStore trustStore = KeyUtil.getKeyStore((String)ksConf.getType());
            String fileName = ksConf.getKeystore().getFile();
            InputStream is = fileName != null ? new FileInputStream(IoUtil.expandFilepath((String)fileName)) : new ByteArrayInputStream(ksConf.getKeystore().getValue());
            char[] password = ksConf.getPassword() == null ? null : ksConf.getPassword().toCharArray();
            trustStore.load(is, password);
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!trustStore.isCertificateEntry(alias)) continue;
                tmpCerts.add((X509Certificate)trustStore.getCertificate(alias));
            }
        } else if (conf.getDir() != null) {
            File dir = new File(conf.getDir());
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.exists() || !file.isFile()) continue;
                    tmpCerts.add(X509Util.parseCert((File)file));
                }
            }
        } else {
            throw new RuntimeException("should not happen, neither keystore nor dir is defined");
        }
        return tmpCerts;
    }

    static {
        SUPPORTED_HASH_ALGORITHMS.add(HashAlgoType.SHA1);
        SUPPORTED_HASH_ALGORITHMS.add(HashAlgoType.SHA224);
        SUPPORTED_HASH_ALGORITHMS.add(HashAlgoType.SHA256);
        SUPPORTED_HASH_ALGORITHMS.add(HashAlgoType.SHA384);
        SUPPORTED_HASH_ALGORITHMS.add(HashAlgoType.SHA512);
    }
}

