/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.crypto.Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.InvalidConfException;
import org.xipki.common.concurrent.ConcurrentBag;
import org.xipki.common.concurrent.ConcurrentBagEntry;
import org.xipki.common.util.Base64;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.springframework.dao.DataAccessException;
import org.xipki.datasource.springframework.dao.DataIntegrityViolationException;
import org.xipki.datasource.springframework.jdbc.DuplicateKeyException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.impl.OcspRespWithCacheInfo;
import org.xipki.ocsp.server.impl.store.db.IssuerEntry;
import org.xipki.ocsp.server.impl.store.db.IssuerStore;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.HashAlgoType;
import org.xipki.security.util.X509Util;

class ResponseCacher {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCacher.class);
    private static final String SQL_ADD_ISSUER = "INSERT INTO ISSUER (ID,S1C,CERT) VALUES (?,?,?)";
    private static final String SQL_SELECT_ISSUER_ID = "SELECT ID FROM ISSUER";
    private static final String SQL_DELETE_ISSUER = "DELETE FROM ISSUER WHERE ID=?";
    private static final String SQL_SELECT_ISSUER = "SELECT ID,CERT FROM ISSUER";
    private static final String SQL_DELETE_EXPIRED_RESP = "DELETE FROM OCSP WHERE THIS_UPDATE<?";
    private static final String SQL_ADD_RESP = "INSERT INTO OCSP (ID,IID,IDENT,THIS_UPDATE,NEXT_UPDATE,RESP) VALUES (?,?,?,?,?,?)";
    private static final String SQL_UPDATE_RESP = "UPDATE OCSP SET THIS_UPDATE=?,NEXT_UPDATE=?,RESP=? WHERE ID=?";
    private final ConcurrentBag<ConcurrentBagEntry<Digest>> idDigesters;
    private final String sqlSelectIssuerCert;
    private final String sqlSelectOcsp;
    private final boolean master;
    private final int validity;
    private final AtomicBoolean onService;
    private DataSourceWrapper datasource;
    private IssuerStore issuerStore;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private ScheduledFuture<?> responseCleaner;
    private ScheduledFuture<?> issuerUpdater;

    ResponseCacher(DataSourceWrapper datasource, boolean master, int validity) {
        this.datasource = (DataSourceWrapper)ParamUtil.requireNonNull((String)"datasource", (Object)datasource);
        this.master = master;
        this.validity = ParamUtil.requireMin((String)"validity", (int)validity, (int)1);
        this.sqlSelectIssuerCert = datasource.buildSelectFirstSql(1, "CERT FROM ISSUER WHERE ID=?");
        this.sqlSelectOcsp = datasource.buildSelectFirstSql(1, "IID,IDENT,THIS_UPDATE,NEXT_UPDATE,RESP FROM OCSP WHERE ID=?");
        this.onService = new AtomicBoolean(false);
        this.idDigesters = new ConcurrentBag();
        for (int i = 0; i < 20; ++i) {
            Digest md = HashAlgoType.SHA1.createDigest();
            this.idDigesters.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)md));
        }
    }

    boolean isOnService() {
        return this.onService.get() && this.issuerStore != null;
    }

    void init() {
        this.updateCacheStore();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        this.responseCleaner = this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new ExpiredResponsesCleaner(), 348L, 600L, TimeUnit.SECONDS);
        this.issuerUpdater = this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new IssuerUpdater(), 448L, 600L, TimeUnit.SECONDS);
    }

    void shutdown() {
        if (this.datasource != null) {
            this.datasource.close();
            this.datasource = null;
        }
        if (this.responseCleaner != null) {
            this.responseCleaner.cancel(false);
            this.responseCleaner = null;
        }
        if (this.issuerUpdater != null) {
            this.issuerUpdater.cancel(false);
            this.issuerUpdater = null;
        }
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            while (!this.scheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.scheduledThreadPoolExecutor = null;
        }
    }

    Integer getIssuerId(RequestIssuer reqIssuer) {
        IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
        return issuer == null ? null : Integer.valueOf(issuer.id());
    }

    synchronized Integer storeIssuer(X509Certificate issuerCert) throws CertificateException, InvalidConfException, DataAccessException {
        Integer n;
        if (!this.master) {
            throw new IllegalStateException("storeIssuer is not permitted in slave mode");
        }
        for (Integer id : this.issuerStore.ids()) {
            if (!this.issuerStore.getIssuerForId(id).cert().equals(issuerCert)) continue;
            return id;
        }
        byte[] encodedCert = issuerCert.getEncoded();
        String sha1FpCert = HashAlgoType.SHA1.base64Hash(encodedCert);
        int maxId = (int)this.datasource.getMax(null, "ISSUER", "ID");
        int id = maxId + 1;
        String sql = SQL_ADD_ISSUER;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(SQL_ADD_ISSUER);
            int idx = 1;
            ps.setInt(idx++, id);
            ps.setString(idx++, sha1FpCert);
            ps.setString(idx++, Base64.encodeToString((byte[])encodedCert));
            ps.execute();
            IssuerEntry newInfo = new IssuerEntry(id, issuerCert);
            this.issuerStore.addIssuer(newInfo);
            n = id;
        }
        catch (SQLException ex) {
            try {
                try {
                    throw this.datasource.translate(SQL_ADD_ISSUER, ex);
                }
                catch (Throwable throwable) {
                    this.datasource.releaseResources((Statement)ps, null);
                    throw throwable;
                }
            }
            catch (DataAccessException ex2) {
                if (ex2 instanceof DuplicateKeyException) {
                    return id;
                }
                throw ex2;
            }
        }
        this.datasource.releaseResources((Statement)ps, null);
        return n;
    }

    OcspRespWithCacheInfo getOcspResponse(int issuerId, BigInteger serialNumber, AlgorithmCode sigAlg, AlgorithmCode certHashAlg) throws DataAccessException {
        String sql = this.sqlSelectOcsp;
        byte[] identBytes = ResponseCacher.buildIdent(serialNumber, sigAlg, certHashAlg);
        long id = this.deriveId(issuerId, identBytes);
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = null;
        try {
            long minNextUpdate;
            String dbIdent;
            ps.setLong(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            int dbIid = rs.getInt("IID");
            if (dbIid != issuerId) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            String ident = Base64.encodeToString((byte[])identBytes);
            if (!ident.equals(dbIdent = rs.getString("IDENT"))) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            long nextUpdate = rs.getLong("NEXT_UPDATE");
            if (nextUpdate != 0L && nextUpdate < (minNextUpdate = System.currentTimeMillis() / 1000L + 600L)) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            long thisUpdate = rs.getLong("THIS_UPDATE");
            String b64Resp = rs.getString("RESP");
            byte[] encoded = Base64.decodeFast((String)b64Resp);
            OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = new OcspRespWithCacheInfo.ResponseCacheInfo(thisUpdate);
            if (nextUpdate != 0L) {
                cacheInfo.setNextUpdate(nextUpdate);
            }
            OcspRespWithCacheInfo ocspRespWithCacheInfo = new OcspRespWithCacheInfo(encoded, cacheInfo);
            return ocspRespWithCacheInfo;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeOcspResponse(int issuerId, BigInteger serialNumber, long thisUpdate, Long nextUpdate, AlgorithmCode sigAlgCode, AlgorithmCode certHashAlgCode, byte[] response) {
        block23: {
            byte[] identBytes = ResponseCacher.buildIdent(serialNumber, sigAlgCode, certHashAlgCode);
            String ident = Base64.encodeToString((byte[])identBytes);
            try {
                long id = this.deriveId(issuerId, identBytes);
                Connection conn = this.datasource.getConnection();
                try {
                    Boolean dataIntegrityViolationException;
                    String b64Response;
                    PreparedStatement ps;
                    String sql;
                    block22: {
                        sql = SQL_ADD_RESP;
                        ps = this.datasource.prepareStatement(conn, sql);
                        b64Response = Base64.encodeToString((byte[])response);
                        dataIntegrityViolationException = null;
                        try {
                            int idx = 1;
                            ps.setLong(idx++, id);
                            ps.setInt(idx++, issuerId);
                            ps.setString(idx++, ident);
                            ps.setLong(idx++, thisUpdate);
                            if (nextUpdate != null && nextUpdate > 0L) {
                                ps.setLong(idx++, nextUpdate);
                            } else {
                                ps.setNull(idx++, -5);
                            }
                            ps.setString(idx++, b64Response);
                            ps.execute();
                        }
                        catch (SQLException ex) {
                            DataAccessException dex = this.datasource.translate(sql, ex);
                            if (dex instanceof DataIntegrityViolationException) {
                                dataIntegrityViolationException = Boolean.TRUE;
                                break block22;
                            }
                            throw dex;
                        }
                        finally {
                            this.datasource.releaseResources((Statement)ps, null, false);
                        }
                    }
                    if (dataIntegrityViolationException == null) {
                        LOG.debug("added cached OCSP response iid={}, ident={}", (Object)issuerId, (Object)ident);
                        return;
                    }
                    sql = SQL_UPDATE_RESP;
                    ps = this.datasource.prepareStatement(conn, sql);
                    try {
                        int idx = 1;
                        ps.setLong(idx++, thisUpdate);
                        if (nextUpdate != null && nextUpdate > 0L) {
                            ps.setLong(idx++, nextUpdate);
                        } else {
                            ps.setNull(idx++, -5);
                        }
                        ps.setString(idx++, b64Response);
                        ps.setLong(idx++, id);
                        ps.executeUpdate();
                    }
                    catch (SQLException ex) {
                        throw this.datasource.translate(sql, ex);
                    }
                    finally {
                        this.datasource.releaseResources((Statement)ps, null, false);
                    }
                }
                finally {
                    this.datasource.returnConnection(conn);
                }
            }
            catch (DataAccessException ex) {
                LOG.info("could not cache OCSP response iid={}, ident={}", (Object)issuerId, (Object)ident);
                if (!LOG.isDebugEnabled()) break block23;
                LOG.debug("could not cache OCSP response iid=" + issuerId + ", ident=" + ident, (Throwable)ex);
            }
        }
    }

    private int removeExpiredResponses(long maxThisUpdate) throws DataAccessException {
        String sql = SQL_DELETE_EXPIRED_RESP;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(SQL_DELETE_EXPIRED_RESP);
            ps.setLong(1, maxThisUpdate);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(SQL_DELETE_EXPIRED_RESP, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void updateCacheStore() {
        boolean stillOnService = this.updateCacheStore0();
        this.onService.set(stillOnService);
        if (!stillOnService) {
            LOG.error("OCSP response cacher is out of service");
        } else {
            LOG.info("OCSP response cacher is on service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean updateCacheStore0() {
        try {
            if (this.issuerStore == null) {
                return this.initIssuerStore();
            }
            PreparedStatement ps = null;
            ResultSet rs = null;
            HashSet<Integer> ids = new HashSet<Integer>();
            try {
                ps = this.prepareStatement(SQL_SELECT_ISSUER_ID);
                rs = ps.executeQuery();
                if (this.master) {
                    boolean bl = true;
                    return bl;
                }
                while (rs.next()) {
                    ids.add(rs.getInt("ID"));
                }
            }
            catch (SQLException ex) {
                LogUtil.error((Logger)LOG, (Throwable)this.datasource.translate(SQL_SELECT_ISSUER_ID, ex), (String)"could not executing updateCacheStore()");
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not executing updateCacheStore()");
                boolean bl = false;
                return bl;
            }
            finally {
                this.datasource.releaseResources((Statement)ps, rs, false);
            }
            ps = null;
            rs = null;
            Set<Integer> currentIds = this.issuerStore.ids();
            for (Integer id : ids) {
                if (currentIds.contains(id)) continue;
                try {
                    if (ps == null) {
                        ps = this.prepareStatement(this.sqlSelectIssuerCert);
                    }
                    ps.setInt(1, id);
                    rs = ps.executeQuery();
                    rs.next();
                    String b64Cert = rs.getString("CERT");
                    X509Certificate cert = X509Util.parseBase64EncodedCert((String)b64Cert);
                    IssuerEntry caInfoEntry = new IssuerEntry(id, cert);
                    this.issuerStore.addIssuer(caInfoEntry);
                    LOG.info("added issuer {}", (Object)id);
                }
                catch (SQLException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)this.datasource.translate(this.sqlSelectIssuerCert, ex), (String)"could not executing updateCacheStore()");
                    boolean bl = false;
                    return bl;
                }
                catch (Exception ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not executing updateCacheStore()");
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.datasource.releaseResources(null, rs, false);
                }
            }
            if (ps != null) {
                this.datasource.releaseResources((Statement)ps, null, false);
            }
        }
        catch (DataAccessException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not executing updateCacheStore()");
            return false;
        }
        catch (CertificateException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not executing updateCacheStore()");
        }
        return true;
    }

    private boolean initIssuerStore() throws DataAccessException, CertificateException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.prepareStatement(SQL_SELECT_ISSUER);
            rs = ps.executeQuery();
            LinkedList<IssuerEntry> caInfos = new LinkedList<IssuerEntry>();
            PreparedStatement deleteIssuerStmt = null;
            while (rs.next()) {
                int id = rs.getInt("ID");
                String b64Cert = rs.getString("CERT");
                X509Certificate cert = X509Util.parseBase64EncodedCert((String)b64Cert);
                IssuerEntry caInfoEntry = new IssuerEntry(id, cert);
                RequestIssuer reqIssuer = new RequestIssuer(HashAlgoType.SHA1, caInfoEntry.getEncodedHash(HashAlgoType.SHA1));
                boolean duplicated = false;
                for (IssuerEntry existingIssuer : caInfos) {
                    if (!existingIssuer.matchHash(reqIssuer)) continue;
                    duplicated = true;
                    break;
                }
                String subject = cert.getSubjectX500Principal().getName();
                if (duplicated) {
                    if (deleteIssuerStmt == null) {
                        deleteIssuerStmt = this.prepareStatement(SQL_DELETE_ISSUER);
                    }
                    deleteIssuerStmt.setInt(1, id);
                    deleteIssuerStmt.executeUpdate();
                    LOG.warn("Delete duplicated issuer {}: {}", (Object)id, (Object)subject);
                    continue;
                }
                LOG.info("added issuer {}: {}", (Object)id, (Object)subject);
                caInfos.add(caInfoEntry);
            }
            this.issuerStore = new IssuerStore(caInfos);
            LOG.info("Updated issuers");
        }
        catch (SQLException ex) {
            throw this.datasource.translate(SQL_SELECT_ISSUER, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs, false);
        }
        return true;
    }

    private PreparedStatement prepareStatement(String sqlQuery) throws DataAccessException {
        Connection conn = this.datasource.getConnection();
        try {
            return this.datasource.prepareStatement(conn, sqlQuery);
        }
        catch (DataAccessException ex) {
            this.datasource.returnConnection(conn);
            throw ex;
        }
    }

    private static byte[] buildIdent(BigInteger serialNumber, AlgorithmCode sigAlg, AlgorithmCode certHashAlg) {
        byte[] snBytes = serialNumber.toByteArray();
        byte[] bytes = new byte[2 + snBytes.length];
        bytes[0] = sigAlg.code();
        bytes[1] = certHashAlg == null ? (byte)0 : certHashAlg.code();
        System.arraycopy(snBytes, 0, bytes, 2, snBytes.length);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deriveId(int issuerId, byte[] identBytes) {
        boolean newDigest;
        ConcurrentBagEntry digest0 = null;
        try {
            digest0 = (ConcurrentBagEntry)this.idDigesters.borrow(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = newDigest = digest0 == null;
        if (newDigest) {
            digest0 = new ConcurrentBagEntry((Object)HashAlgoType.SHA1.createDigest());
        }
        byte[] hash = new byte[20];
        try {
            Digest digest = (Digest)digest0.value();
            digest.reset();
            digest.update(ResponseCacher.int2Bytes(issuerId), 0, 2);
            digest.update(identBytes, 0, identBytes.length);
            digest.doFinal(hash, 0);
        }
        finally {
            if (newDigest) {
                this.idDigesters.add((ConcurrentBag.IConcurrentBagEntry)digest0);
            } else {
                this.idDigesters.requite((ConcurrentBag.IConcurrentBagEntry)digest0);
            }
        }
        return (0x7FL & (long)hash[0]) << 56 | (0xFFL & (long)hash[1]) << 48 | (0xFFL & (long)hash[2]) << 40 | (0xFFL & (long)hash[3]) << 32 | (0xFFL & (long)hash[4]) << 24 | (0xFFL & (long)hash[5]) << 16 | (0xFFL & (long)hash[6]) << 8 | 0xFFL & (long)hash[7];
    }

    private static byte[] int2Bytes(int value) {
        if (value < 65535) {
            return new byte[]{(byte)(value >> 8), (byte)value};
        }
        throw new IllegalArgumentException("value is too large");
    }

    private class ExpiredResponsesCleaner
    implements Runnable {
        private boolean inProcess;

        private ExpiredResponsesCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            long maxThisUpdate = System.currentTimeMillis() / 1000L - (long)ResponseCacher.this.validity;
            try {
                int num = ResponseCacher.this.removeExpiredResponses(maxThisUpdate);
                LOG.info("removed {} response with thisUpdate < {}", (Object)num, (Object)maxThisUpdate);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove expired responses");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class IssuerUpdater
    implements Runnable {
        private IssuerUpdater() {
        }

        @Override
        public void run() {
            try {
                ResponseCacher.this.updateCacheStore();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while calling updateCacheStore()");
            }
        }
    }
}

