/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.Arrays;
import org.xipki.common.ASN1Type;
import org.xipki.ocsp.server.impl.type.ExtendedExtension;
import org.xipki.ocsp.server.impl.type.OID;
import org.xipki.ocsp.server.impl.type.WritableOnlyExtension;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgoType;

class Template {
    private static final Map<HashAlgoType, byte[]> extnCerthashPrefixMap = new HashMap<HashAlgoType, byte[]>();
    private static final byte[] extnInvalidityDate;
    private static final byte[] extnArchiveCutof;
    private static final byte[] revokedInfoNoReasonPrefix;
    private static final byte[] revokedInfoWithReasonPrefix;
    private static final byte[] reasonPrefix;

    Template() {
    }

    public static WritableOnlyExtension getCertHashExtension(HashAlgoType hashAlgo, byte[] certHash) {
        if (hashAlgo.length() != certHash.length) {
            throw new IllegalArgumentException("hashAlgo and certHash do not match");
        }
        byte[] encodedPrefix = extnCerthashPrefixMap.get(hashAlgo);
        byte[] rv = new byte[encodedPrefix.length + certHash.length];
        System.arraycopy(encodedPrefix, 0, rv, 0, encodedPrefix.length);
        System.arraycopy(certHash, 0, rv, encodedPrefix.length, certHash.length);
        return new WritableOnlyExtension(rv);
    }

    public static WritableOnlyExtension getInvalidityDateExtension(Date invalidityDate) {
        int len = extnInvalidityDate.length;
        byte[] encoded = new byte[len];
        System.arraycopy(extnInvalidityDate, 0, encoded, 0, len - 17);
        ASN1Type.writeGeneralizedTime((Date)invalidityDate, (byte[])encoded, (int)(len - 17));
        return new WritableOnlyExtension(encoded);
    }

    public static WritableOnlyExtension getArchiveOffExtension(Date archiveCutoff) {
        int len = extnArchiveCutof.length;
        byte[] encoded = new byte[len];
        System.arraycopy(extnArchiveCutof, 0, encoded, 0, len - 17);
        ASN1Type.writeGeneralizedTime((Date)archiveCutoff, (byte[])encoded, (int)(len - 17));
        return new WritableOnlyExtension(encoded);
    }

    public static byte[] getEncodeRevokedInfo(CrlReason reason, Date revocationTime) {
        if (reason == null) {
            byte[] encoded = new byte[19];
            System.arraycopy(revokedInfoNoReasonPrefix, 0, encoded, 0, 2);
            ASN1Type.writeGeneralizedTime((Date)revocationTime, (byte[])encoded, (int)2);
            return encoded;
        }
        byte[] encoded = new byte[24];
        System.arraycopy(revokedInfoWithReasonPrefix, 0, encoded, 0, 2);
        ASN1Type.writeGeneralizedTime((Date)revocationTime, (byte[])encoded, (int)2);
        System.arraycopy(reasonPrefix, 0, encoded, 19, 4);
        encoded[23] = (byte)reason.code();
        return encoded;
    }

    static {
        revokedInfoNoReasonPrefix = new byte[]{-95, 17};
        revokedInfoWithReasonPrefix = new byte[]{-95, 22};
        reasonPrefix = new byte[]{-96, 3, 10, 1};
        for (HashAlgoType h : HashAlgoType.values()) {
            byte[] encoded;
            int hlen = h.length();
            AlgorithmIdentifier algId = new AlgorithmIdentifier(h.oid(), (ASN1Encodable)DERNull.INSTANCE);
            try {
                encoded = new CertHash(algId, new byte[hlen]).getEncoded();
            }
            catch (IOException ex) {
                throw new ExceptionInInitializerError("could not processing encoding of CertHash");
            }
            byte[] prefix = Arrays.copyOf((byte[])encoded, (int)(encoded.length - hlen));
            extnCerthashPrefixMap.put(h, prefix);
        }
        ExtendedExtension extension = new ExtendedExtension(OID.ID_INVALIDITY_DATE, false, new byte[17]);
        extnInvalidityDate = new byte[extension.encodedLength()];
        extension.write(extnInvalidityDate, 0);
        extension = new ExtendedExtension(OID.ID_PKIX_OCSP_ARCHIVE_CUTOFF, false, new byte[17]);
        extnArchiveCutof = new byte[extension.encodedLength()];
        extension.write(extnArchiveCutof, 0);
    }
}

