/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.store.db;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.Base64;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.springframework.dao.DataAccessException;
import org.xipki.ocsp.api.CertStatus;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.impl.store.db.CrlInfo;
import org.xipki.ocsp.server.impl.store.db.IssuerEntry;
import org.xipki.ocsp.server.impl.store.db.IssuerFilter;
import org.xipki.ocsp.server.impl.store.db.IssuerStore;
import org.xipki.ocsp.server.impl.store.db.StoreConf;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgoType;
import org.xipki.security.util.X509Util;

public class DbCertStatusStore
extends OcspStore {
    protected DataSourceWrapper datasource;
    private static final Logger LOG = LoggerFactory.getLogger(DbCertStatusStore.class);
    private final AtomicBoolean storeUpdateInProcess = new AtomicBoolean(false);
    private String sqlCsNoRit;
    private String sqlCs;
    private Map<HashAlgoType, String> sqlCsNoRitMap;
    private Map<HashAlgoType, String> sqlCsMap;
    private IssuerFilter issuerFilter;
    private IssuerStore issuerStore;
    private boolean initialized;
    private boolean initializationFailed;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    protected List<Runnable> getScheduledServices() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initIssuerStore() {
        if (this.storeUpdateInProcess.get()) {
            return;
        }
        this.storeUpdateInProcess.set(true);
        try {
            String sha1Fp;
            ResultSet rs;
            PreparedStatement ps;
            String sql;
            if (this.initialized) {
                sql = "SELECT ID,REV,RT,S1C FROM ISSUER";
                ps = this.preparedStatement("SELECT ID,REV,RT,S1C FROM ISSUER");
                rs = null;
                try {
                    boolean issuersUnchanged;
                    HashMap<Integer, SimpleIssuerEntry> newIssuers = new HashMap<Integer, SimpleIssuerEntry>();
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        sha1Fp = rs.getString("S1C");
                        if (!this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp)) continue;
                        int id = rs.getInt("ID");
                        boolean revoked = rs.getBoolean("REV");
                        Iterator revTimeMs = revoked ? Long.valueOf(rs.getLong("RT") * 1000L) : null;
                        SimpleIssuerEntry issuerEntry = new SimpleIssuerEntry(id, (Long)((Object)revTimeMs));
                        newIssuers.put(id, issuerEntry);
                    }
                    Set newIds = newIssuers.keySet();
                    Set ids = this.issuerStore != null ? this.issuerStore.ids() : Collections.emptySet();
                    boolean bl = issuersUnchanged = ids.size() == newIds.size() && ids.containsAll(newIds) && newIds.containsAll(ids);
                    if (issuersUnchanged) {
                        for (Integer id : newIds) {
                            IssuerEntry entry = this.issuerStore.getIssuerForId(id);
                            SimpleIssuerEntry newEntry = (SimpleIssuerEntry)newIssuers.get(id);
                            if (!newEntry.match(entry)) continue;
                            issuersUnchanged = false;
                            break;
                        }
                    }
                    if (issuersUnchanged) {
                        return;
                    }
                }
                finally {
                    this.releaseDbResources(ps, rs);
                }
            }
            sql = "SELECT ID,NBEFORE,REV,RT,S1C,CERT,CRL_INFO FROM ISSUER";
            ps = this.preparedStatement("SELECT ID,NBEFORE,REV,RT,S1C,CERT,CRL_INFO FROM ISSUER");
            rs = null;
            try {
                rs = ps.executeQuery();
                LinkedList<IssuerEntry> caInfos = new LinkedList<IssuerEntry>();
                while (rs.next()) {
                    sha1Fp = rs.getString("S1C");
                    if (!this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp)) continue;
                    int id = rs.getInt("ID");
                    String b64Cert = rs.getString("CERT");
                    X509Certificate cert = X509Util.parseBase64EncodedCert((String)b64Cert);
                    IssuerEntry caInfoEntry = new IssuerEntry(id, cert);
                    String crlInfoStr = rs.getString("CRL_INFO");
                    if (StringUtil.isNotBlank((String)crlInfoStr)) {
                        CrlInfo crlInfo = new CrlInfo(crlInfoStr);
                        caInfoEntry.setCrlInfo(crlInfo);
                    }
                    RequestIssuer reqIssuer = new RequestIssuer(HashAlgoType.SHA1, caInfoEntry.getEncodedHash(HashAlgoType.SHA1));
                    for (IssuerEntry existingIssuer : caInfos) {
                        if (!existingIssuer.matchHash(reqIssuer)) continue;
                        throw new Exception("found at least two issuers with the same subject and key");
                    }
                    boolean revoked = rs.getBoolean("REV");
                    if (revoked) {
                        long lo = rs.getLong("RT");
                        caInfoEntry.setRevocationInfo(new Date(lo * 1000L));
                    }
                    caInfos.add(caInfoEntry);
                }
                this.initialized = false;
                this.issuerStore = new IssuerStore(caInfos);
                LOG.info("Updated issuers: {}", (Object)this.name);
                this.initializationFailed = false;
                this.initialized = true;
            }
            finally {
                this.releaseDbResources(ps, rs);
            }
        }
        catch (Throwable th) {
            this.storeUpdateInProcess.set(false);
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not executing initIssuerStore()");
            this.initializationFailed = true;
            this.initialized = true;
        }
    }

    public CertStatusInfo getCertStatus(Date time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation, HashAlgoType certHashAlg) throws OcspStoreException {
        if (serialNumber.signum() != 1) {
            return CertStatusInfo.getUnknownCertStatusInfo((Date)new Date(), null);
        }
        if (!this.initialized) {
            throw new OcspStoreException("initialization of CertStore is still in process");
        }
        if (this.initializationFailed) {
            throw new OcspStoreException("initialization of CertStore failed");
        }
        try {
            Date thisUpdate;
            String sql;
            IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
            if (issuer == null) {
                return null;
            }
            HashAlgoType certHashAlgo = null;
            if (includeCertHash) {
                certHashAlgo = certHashAlg == null ? reqIssuer.hashAlgorithm() : certHashAlg;
                sql = (includeRit ? this.sqlCsMap : this.sqlCsNoRitMap).get(certHashAlgo);
            } else {
                sql = includeRit ? this.sqlCs : this.sqlCsNoRit;
            }
            CrlInfo crlInfo = issuer.crlInfo();
            Date nextUpdate = null;
            if (crlInfo != null && crlInfo.isUseCrlUpdates()) {
                thisUpdate = crlInfo.thisUpdate();
                if (crlInfo.nextUpdate().getTime() - System.currentTimeMillis() > 10000L) {
                    nextUpdate = crlInfo.nextUpdate();
                }
            } else {
                thisUpdate = new Date();
            }
            ResultSet rs = null;
            CertStatusInfo certStatusInfo = null;
            boolean unknown = true;
            boolean ignore = false;
            String certprofile = null;
            String b64CertHash = null;
            boolean revoked = false;
            int reason = 0;
            long revTime = 0L;
            long invalTime = 0L;
            PreparedStatement ps = this.datasource.prepareStatement(this.datasource.getConnection(), sql);
            try {
                ps.setInt(1, issuer.id());
                ps.setString(2, serialNumber.toString(16));
                rs = ps.executeQuery();
                if (rs.next()) {
                    long notAfterInSec;
                    long notBeforeInSec;
                    unknown = false;
                    long timeInSec = time.getTime() / 1000L;
                    if (!ignore && this.ignoreNotYetValidCert && (notBeforeInSec = rs.getLong("NBEFORE")) != 0L && timeInSec < notBeforeInSec) {
                        ignore = true;
                    }
                    if (!ignore && this.ignoreExpiredCert && (notAfterInSec = rs.getLong("NAFTER")) != 0L && timeInSec > notAfterInSec) {
                        ignore = true;
                    }
                    if (!ignore) {
                        if (certHashAlgo != null) {
                            b64CertHash = rs.getString(certHashAlgo.getShortName());
                        }
                        if (revoked = rs.getBoolean("REV")) {
                            reason = rs.getInt("RR");
                            revTime = rs.getLong("RT");
                            if (includeRit) {
                                invalTime = rs.getLong("RIT");
                            }
                        }
                    }
                }
                this.releaseDbResources(ps, rs);
            }
            catch (SQLException ex) {
                try {
                    throw this.datasource.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.releaseDbResources(ps, rs);
                    throw throwable;
                }
            }
            if (unknown) {
                certStatusInfo = this.unknownSerialAsGood ? CertStatusInfo.getGoodCertStatusInfo((HashAlgoType)certHashAlgo, null, (Date)thisUpdate, (Date)nextUpdate, null) : CertStatusInfo.getUnknownCertStatusInfo((Date)thisUpdate, (Date)nextUpdate);
            } else if (ignore) {
                certStatusInfo = CertStatusInfo.getIgnoreCertStatusInfo((Date)thisUpdate, (Date)nextUpdate);
            } else {
                byte[] certHash;
                byte[] byArray = certHash = b64CertHash == null ? null : Base64.decodeFast(b64CertHash);
                if (revoked) {
                    Date invTime = invalTime == 0L || invalTime == revTime ? null : new Date(invalTime * 1000L);
                    CertRevocationInfo revInfo = new CertRevocationInfo(reason, new Date(revTime * 1000L), invTime);
                    certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)revInfo, (HashAlgoType)certHashAlgo, (byte[])certHash, (Date)thisUpdate, (Date)nextUpdate, certprofile);
                } else {
                    certStatusInfo = CertStatusInfo.getGoodCertStatusInfo((HashAlgoType)certHashAlgo, (byte[])certHash, (Date)thisUpdate, (Date)nextUpdate, certprofile);
                }
            }
            if (this.includeCrlId && crlInfo != null) {
                certStatusInfo.setCrlId(crlInfo.crlId());
            }
            if (this.includeArchiveCutoff && this.retentionInterval != 0) {
                Date date;
                if (this.retentionInterval < 0) {
                    date = issuer.notBefore();
                } else {
                    long nowInMs = System.currentTimeMillis();
                    long dateInMs = Math.max(issuer.notBefore().getTime(), nowInMs - 86400000L * (long)this.retentionInterval);
                    date = new Date(dateInMs);
                }
                certStatusInfo.setArchiveCutOff(date);
            }
            if (!inheritCaRevocation || issuer.revocationInfo() == null) {
                return certStatusInfo;
            }
            CertRevocationInfo caRevInfo = issuer.revocationInfo();
            CertStatus certStatus = certStatusInfo.certStatus();
            boolean replaced = false;
            if (certStatus == CertStatus.GOOD || certStatus == CertStatus.UNKNOWN) {
                replaced = true;
            } else if (certStatus == CertStatus.REVOKED && certStatusInfo.revocationInfo().revocationTime().after(caRevInfo.revocationTime())) {
                replaced = true;
            }
            if (replaced) {
                CertRevocationInfo newRevInfo = caRevInfo.reason() == CrlReason.CA_COMPROMISE ? caRevInfo : new CertRevocationInfo(CrlReason.CA_COMPROMISE, caRevInfo.revocationTime(), caRevInfo.invalidityTime());
                certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)newRevInfo, (HashAlgoType)certStatusInfo.certHashAlgo(), (byte[])certStatusInfo.certHash(), (Date)certStatusInfo.thisUpdate(), (Date)certStatusInfo.nextUpdate(), (String)certStatusInfo.certprofile());
            }
            return certStatusInfo;
        }
        catch (DataAccessException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
    }

    private PreparedStatement preparedStatement(String sqlQuery) throws DataAccessException {
        return this.datasource.prepareStatement(this.datasource.getConnection(), sqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        if (!this.isInitialized()) {
            return false;
        }
        if (this.isInitializationFailed()) {
            return false;
        }
        String sql = "SELECT ID FROM ISSUER";
        PreparedStatement ps = this.preparedStatement("SELECT ID FROM ISSUER");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            boolean bl = true;
            this.releaseDbResources(ps, rs);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.releaseDbResources(ps, rs);
                throw throwable;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
        }
    }

    private void releaseDbResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs);
    }

    public void init(String conf, DataSourceWrapper datasource) throws OcspStoreException {
        HashAlgoType[] hashAlgos;
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        this.datasource = (DataSourceWrapper)ParamUtil.requireNonNull((String)"datasource", (Object)datasource);
        this.sqlCs = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsNoRit = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsMap = new HashMap<HashAlgoType, String>();
        this.sqlCsNoRitMap = new HashMap<HashAlgoType, String>();
        for (HashAlgoType hashAlgo : hashAlgos = new HashAlgoType[]{HashAlgoType.SHA1, HashAlgoType.SHA224, HashAlgoType.SHA256, HashAlgoType.SHA384, HashAlgoType.SHA512}) {
            String coreSql = "NBEFORE,NAFTER,ID,REV,RR,RT,RIT," + hashAlgo.getShortName() + " FROM CERT INNER JOIN CHASH ON CERT.IID=? AND CERT.SN=? AND CERT.ID=CHASH.CID";
            this.sqlCsMap.put(hashAlgo, datasource.buildSelectFirstSql(1, coreSql));
            coreSql = "NBEFORE,NAFTER,ID,REV,RR,RT," + hashAlgo.getShortName() + " FROM CERT INNER JOIN CHASH ON CERT.IID=? AND CERT.SN=? AND CERT.ID=CHASH.CID";
            this.sqlCsNoRitMap.put(hashAlgo, datasource.buildSelectFirstSql(1, coreSql));
        }
        StoreConf storeConf = new StoreConf(conf);
        try {
            Set<X509Certificate> includeIssuers = null;
            Set<X509Certificate> excludeIssuers = null;
            if (CollectionUtil.isNonEmpty(storeConf.caCertsIncludes())) {
                includeIssuers = DbCertStatusStore.parseCerts(storeConf.caCertsIncludes());
            }
            if (CollectionUtil.isNonEmpty(storeConf.caCertsExcludes())) {
                excludeIssuers = DbCertStatusStore.parseCerts(storeConf.caCertsExcludes());
            }
            this.issuerFilter = new IssuerFilter(includeIssuers, excludeIssuers);
        }
        catch (CertificateException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
        this.initIssuerStore();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        StoreUpdateService storeUpdateService = new StoreUpdateService();
        List<Runnable> scheduledServices = this.getScheduledServices();
        int size = 1;
        if (scheduledServices != null) {
            size += scheduledServices.size();
        }
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(size);
        Random random = new Random();
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(storeUpdateService, 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
        if (scheduledServices != null) {
            for (Runnable service : scheduledServices) {
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(service, 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
            }
        }
    }

    public void shutdown() throws OcspStoreException {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            this.scheduledThreadPoolExecutor = null;
        }
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    public boolean canResolveIssuer(RequestIssuer reqIssuer) {
        return null != this.issuerStore.getIssuerForFp(reqIssuer);
    }

    public X509Certificate getIssuerCert(RequestIssuer reqIssuer) {
        IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
        return issuer == null ? null : issuer.cert();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isInitializationFailed() {
        return this.initializationFailed;
    }

    private static Set<X509Certificate> parseCerts(Set<String> certFiles) throws OcspStoreException {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>(certFiles.size());
        for (String certFile : certFiles) {
            try {
                certs.add(X509Util.parseCert((String)certFile));
            }
            catch (IOException | CertificateException ex) {
                throw new OcspStoreException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return certs;
    }

    private class StoreUpdateService
    implements Runnable {
        private StoreUpdateService() {
        }

        @Override
        public void run() {
            DbCertStatusStore.this.initIssuerStore();
        }
    }

    private static class SimpleIssuerEntry {
        private final int id;
        private final Long revocationTimeMs;

        SimpleIssuerEntry(int id, Long revocationTimeMs) {
            this.id = id;
            this.revocationTimeMs = revocationTimeMs;
        }

        public boolean match(IssuerEntry issuer) {
            if (this.id != issuer.id()) {
                return false;
            }
            if (this.revocationTimeMs == null) {
                return issuer.revocationInfo() == null;
            }
            return issuer.revocationInfo() == null ? false : this.revocationTimeMs.longValue() == issuer.revocationInfo().revocationTime().getTime();
        }
    }
}

