/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.store.db;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;

public class IssuerFilter {
    private final Set<String> includeSha1Fps;
    private final Set<String> excludeSha1Fps;

    public IssuerFilter(Set<X509Certificate> includes, Set<X509Certificate> excludes) throws CertificateEncodingException {
        String sha1Fp;
        if (includes == null) {
            this.includeSha1Fps = null;
        } else {
            this.includeSha1Fps = new HashSet<String>(includes.size());
            for (X509Certificate include : includes) {
                sha1Fp = HashAlgoType.SHA1.base64Hash(include.getEncoded());
                this.includeSha1Fps.add(sha1Fp);
            }
        }
        if (excludes == null) {
            this.excludeSha1Fps = null;
        } else {
            this.excludeSha1Fps = new HashSet<String>(excludes.size());
            for (X509Certificate exclude : excludes) {
                sha1Fp = HashAlgoType.SHA1.base64Hash(exclude.getEncoded());
                this.excludeSha1Fps.add(sha1Fp);
            }
        }
    }

    public boolean includeIssuerWithSha1Fp(String sha1Fp) {
        ParamUtil.requireNonBlank((String)"sha1Fp", (String)sha1Fp);
        if (this.includeSha1Fps == null || this.includeSha1Fps.contains(sha1Fp)) {
            return this.excludeSha1Fps == null ? true : !this.excludeSha1Fps.contains(sha1Fp);
        }
        return false;
    }
}

