/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.server.impl.type.EncodingException;
import org.xipki.ocsp.server.impl.type.Extension;
import org.xipki.ocsp.server.impl.type.OID;
import org.xipki.ocsp.server.impl.type.OcspRequest;

public class ExtendedExtension
extends Extension {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedExtension.class);
    private static final byte[] bytes_critical = Hex.decode((String)"0101FF");
    private final OID extnType;
    private final byte[] encoded;
    private final int from;
    private final boolean critical;
    private final int encodedLength;
    private final int extnValueFrom;
    private final int extnValueLength;

    public ExtendedExtension(OID extnType, boolean critical, byte[] extnValue) {
        int bodyLen = extnType.encodedLength();
        if (critical) {
            bodyLen += 3;
        }
        this.extnType = extnType;
        this.critical = critical;
        this.encodedLength = ExtendedExtension.getLen((int)(bodyLen += ExtendedExtension.getLen((int)extnValue.length)));
        this.extnValueLength = extnValue.length;
        this.extnValueFrom = this.encodedLength - this.extnValueLength;
        this.from = 0;
        this.encoded = new byte[this.encodedLength];
        int offset = ExtendedExtension.writeHeader((byte)48, (int)bodyLen, (byte[])this.encoded, (int)0);
        offset += extnType.write(this.encoded, offset);
        if (critical) {
            offset += ExtendedExtension.arraycopy((byte[])bytes_critical, (byte[])this.encoded, (int)offset);
        }
        offset += ExtendedExtension.writeHeader((byte)4, (int)extnValue.length, (byte[])this.encoded, (int)offset);
        ExtendedExtension.arraycopy((byte[])extnValue, (byte[])this.encoded, (int)offset);
    }

    private ExtendedExtension(OID extnType, byte[] encoded, int from, boolean critical, int encodedLength, int extnValueFrom, int extnValueLength) {
        this.extnType = extnType;
        this.encoded = encoded;
        this.from = from;
        this.critical = critical;
        this.encodedLength = encodedLength;
        this.extnValueFrom = extnValueFrom;
        this.extnValueLength = extnValueLength;
    }

    public static ExtendedExtension getInstance(byte[] encoded, int from, int len) throws EncodingException {
        OcspRequest.Header hdrExtValue;
        boolean critical;
        OcspRequest.Header hdrExtn = OcspRequest.readHeader(encoded, from);
        OcspRequest.Header hdrOid = OcspRequest.readHeader(encoded, hdrExtn.readerIndex);
        OcspRequest.Header hdrNext = OcspRequest.readHeader(encoded, hdrOid.readerIndex + hdrOid.len);
        if (hdrNext.tag == 1) {
            critical = encoded[hdrNext.readerIndex] == -1;
            hdrExtValue = OcspRequest.readHeader(encoded, hdrNext.readerIndex + hdrNext.len);
        } else {
            critical = false;
            hdrExtValue = hdrNext;
        }
        OID extnType = OID.getInstanceForEncoded(encoded, hdrOid.tagIndex);
        if (extnType == null) {
            byte[] bytes = new byte[hdrOid.readerIndex - hdrOid.tagIndex + hdrOid.len];
            System.arraycopy(encoded, hdrOid.tag, bytes, 0, bytes.length);
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)bytes);
            LOG.warn("unknown extension {}", (Object)oid.getId());
            if (critical) {
                throw new EncodingException("unkown critical extension: " + oid.getId());
            }
            return null;
        }
        int extnValueFrom = hdrExtValue.readerIndex;
        int extnValueLength = hdrExtValue.len;
        return new ExtendedExtension(extnType, encoded, from, critical, len, extnValueFrom, extnValueLength);
    }

    public static int getEncodedLength(OID extnType, boolean critical, int extnValueLength) {
        int bodyLen = extnType.encodedLength();
        if (critical) {
            bodyLen += 3;
        }
        return ExtendedExtension.getLen((int)(bodyLen += ExtendedExtension.getLen((int)extnValueLength)));
    }

    public boolean isCritical() {
        return this.critical;
    }

    public OID extnType() {
        return this.extnType;
    }

    public int extnValueLength() {
        return this.extnValueLength;
    }

    public int encodedLength() {
        return this.encodedLength;
    }

    public InputStream getExtnValueStream() {
        return new ByteArrayInputStream(this.encoded, this.extnValueFrom, this.extnValueLength);
    }

    public int write(byte[] out, int offset) {
        System.arraycopy(this.encoded, this.from, out, offset, this.encodedLength);
        return this.encodedLength;
    }

    public int writeExtnValue(byte[] out, int offset) {
        System.arraycopy(this.encoded, this.extnValueFrom, out, offset, this.extnValueLength);
        return this.extnValueLength;
    }
}

