/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.util.Objects;

public enum DatabaseType {
    H2,
    DB2,
    HSQL,
    MYSQL,
    MARIADB,
    ORACLE,
    POSTGRES,
    UNKNOWN;


    public static DatabaseType forDriver(String driverClass) {
        Objects.requireNonNull(driverClass, "driverClass must not be null");
        return DatabaseType.getDatabaseType(driverClass);
    }

    public static DatabaseType forDataSourceClass(String datasourceClass) {
        Objects.requireNonNull(datasourceClass, "datasourceClass must not be null");
        return DatabaseType.getDatabaseType(datasourceClass);
    }

    private static DatabaseType getDatabaseType(String className) {
        if (className.contains("db2.")) {
            return DB2;
        }
        if (className.contains("h2.")) {
            return H2;
        }
        if (className.contains("hsqldb.")) {
            return HSQL;
        }
        if (className.contains("mysql.")) {
            return MYSQL;
        }
        if (className.contains("mariadb.")) {
            return MARIADB;
        }
        if (className.contains("oracle.")) {
            return ORACLE;
        }
        if (className.contains("postgres.") || className.contains("postgresql.")) {
            return POSTGRES;
        }
        return UNKNOWN;
    }
}

