/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xipki.common.util.ParamUtil;
import org.xipki.datasource.DatabaseType;

public class SqlStateCodes {
    private static final String BGE_DYNAMIC_SQL_ERROR = "07";
    private static final String BGE_CARDINALITY_VIOLATION = "21";
    private static final String BGE_SYNTAX_ERROR_DIRECT_SQL = "2A";
    private static final String BGE_SYNTAX_ERROR_DYNAMIC_SQL = "37";
    private static final String BGE_GENERAL_SQL_SYNTAX_ERROR = "42";
    private static final String DIV_DATA_TRUNCATION = "01";
    private static final String DIV_NO_DATA_FOUND = "02";
    private static final String DIV_VALUE_OUTOF_RANGE = "22";
    private static final String DIV_INTEGRITY_CONSTRAINT_VIOLATION = "23";
    private static final String DIV_TRIGGERED_DATA_CHANGE_VIOLATION = "27";
    private static final String DIV_WITH_CHECK_VIOLATION = "44";
    private static final String DRF_CONNECTION_EXCEPTION = "08";
    private static final String TDR_COMMUNICATION_FAILURE = "S1";
    private static final String CF_TRANSACTION_ROLLBACK = "40";
    protected Set<String> badSqlGrammarCodes = SqlStateCodes.toSet("07", "21", "2A", "37", "42");
    protected Set<String> dataIntegrityViolationCodes = SqlStateCodes.toSet("01", "23", "02", "27", "22", "44");
    protected Set<String> dataAccessResourceFailureCodes = SqlStateCodes.toSet("08");
    protected Set<String> transientDataAccessResourceCodes = SqlStateCodes.toSet("S1");
    protected Set<String> concurrencyFailureCodes = SqlStateCodes.toSet("40");

    private SqlStateCodes() {
    }

    public Set<String> badSqlGrammarCodes() {
        return this.badSqlGrammarCodes;
    }

    public Set<String> dataIntegrityViolationCodes() {
        return this.dataIntegrityViolationCodes;
    }

    public Set<String> dataAccessResourceFailureCodes() {
        return this.dataAccessResourceFailureCodes;
    }

    public Set<String> transientDataAccessResourceCodes() {
        return this.transientDataAccessResourceCodes;
    }

    public Set<String> concurrencyFailureCodes() {
        return this.concurrencyFailureCodes;
    }

    public static SqlStateCodes newInstance(DatabaseType dbType) {
        ParamUtil.requireNonNull((String)"dbType", (Object)((Object)dbType));
        switch (dbType) {
            case DB2: {
                return new DB2();
            }
            case H2: {
                return new H2();
            }
            case HSQL: {
                return new HSQL();
            }
            case MYSQL: {
                return new MySQL();
            }
            case MARIADB: {
                return new MariaDB();
            }
            case ORACLE: {
                return new Oracle();
            }
            case POSTGRES: {
                return new PostgreSQL();
            }
            case UNKNOWN: {
                return new SqlStateCodes();
            }
        }
        throw new RuntimeException("should not reach here, unknown database type " + (Object)((Object)dbType));
    }

    private static Set<String> toSet(String ... strs) {
        if (strs == null || strs.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : strs) {
            set.add(str);
        }
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> addToSet(Set<String> baseSet, String ... strs) {
        if (strs == null || strs.length == 0) {
            return baseSet;
        }
        HashSet<String> newSet = new HashSet<String>(baseSet.size() + strs.length);
        newSet.addAll(baseSet);
        for (String str : strs) {
            newSet.add(str);
        }
        return Collections.unmodifiableSet(newSet);
    }

    private static class PostgreSQL
    extends SqlStateCodes {
        PostgreSQL() {
            this.dataAccessResourceFailureCodes = SqlStateCodes.addToSet(this.dataAccessResourceFailureCodes, new String[]{"53", "54"});
        }
    }

    private static class Oracle
    extends SqlStateCodes {
        Oracle() {
            this.badSqlGrammarCodes = SqlStateCodes.addToSet(this.badSqlGrammarCodes, new String[]{"65"});
            this.concurrencyFailureCodes = SqlStateCodes.addToSet(this.concurrencyFailureCodes, new String[]{"61"});
        }
    }

    private static class MariaDB
    extends MySQL {
        MariaDB() {
        }
    }

    private static class MySQL
    extends SqlStateCodes {
        MySQL() {
        }
    }

    private static class HSQL
    extends SqlStateCodes {
        HSQL() {
        }
    }

    private static class H2
    extends SqlStateCodes {
        H2() {
        }
    }

    private static class DB2
    extends SqlStateCodes {
        DB2() {
            this.dataAccessResourceFailureCodes = SqlStateCodes.addToSet(this.dataAccessResourceFailureCodes, new String[]{"57", "58"});
            this.transientDataAccessResourceCodes = SqlStateCodes.addToSet(this.transientDataAccessResourceCodes, new String[]{"51"});
        }
    }
}

