/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixToNamespaceUri = new HashMap<String, String>();
    private Map<String, List<String>> namespaceUriToPrefixes = new HashMap<String, List<String>>();
    private String defaultNamespaceUri = "";

    @Override
    public String getNamespaceURI(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if ("".equals(prefix)) {
            return this.defaultNamespaceUri;
        }
        if (this.prefixToNamespaceUri.containsKey(prefix)) {
            return this.prefixToNamespaceUri.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        List<String> prefixes = this.getPrefixesSafely(namespaceURI);
        if (prefixes.size() == 0) {
            return null;
        }
        return prefixes.get(0);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return this.getPrefixesSafely(namespaceURI).iterator();
    }

    private List<String> getPrefixesSafely(String namespaceURI) {
        List<String> prefixes = this.namespaceUriToPrefixes.get(namespaceURI);
        if (prefixes == null) {
            prefixes = new ArrayList<String>();
            this.namespaceUriToPrefixes.put(namespaceURI, prefixes);
        }
        return prefixes;
    }

    public static SimpleNamespaceContext aNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    public void bind(String prefix, String namespaceURI) {
        this.prefixToNamespaceUri.put(prefix, namespaceURI);
        this.getPrefixesSafely(namespaceURI).add(prefix);
    }

    public void setBindings(Map<String, String> bindings) {
        for (Map.Entry<String, String> entry : bindings.entrySet()) {
            this.bind(entry.getKey(), entry.getValue());
        }
    }

    public SimpleNamespaceContext withBinding(String prefix, String namespaceURI) {
        this.bind(prefix, namespaceURI);
        return this;
    }
}

