/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.transform;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Node;
import org.xmlmatchers.transform.IdentityTransformer;
import org.xmlmatchers.transform.StringResult;
import org.xmlmatchers.transform.StringSource;

public class XmlConverters {
    private XmlConverters() {
    }

    public static Source the(Source xml) {
        return xml;
    }

    public static Source the(String xml) {
        return StringSource.toSource(xml);
    }

    public static Source the(final Node node) {
        return new DOMSource(node){

            public String toString() {
                IdentityTransformer transformer = new IdentityTransformer();
                DOMSource source = new DOMSource(node);
                StringResult result = new StringResult();
                transformer.transform(source, result);
                return result.toString();
            }
        };
    }

    public static Source the(StringResult xml) {
        return StringSource.toSource(xml.toString());
    }

    public static Source xml(Source xml) {
        return XmlConverters.the(xml);
    }

    public static Source xml(String xml) {
        return XmlConverters.the(xml);
    }

    public static Source xml(Node node) {
        return XmlConverters.the(node);
    }

    public static Source xml(StringResult xml) {
        return XmlConverters.the(xml);
    }
}

