/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.adapter;

import org.xmlobjects.gml.model.base.AggregationAttributes;
import org.xmlobjects.gml.model.base.AggregationType;
import org.xmlobjects.gml.model.base.AssociationAttributes;
import org.xmlobjects.gml.model.base.OwnershipAttributes;
import org.xmlobjects.gml.model.basictypes.NilReason;
import org.xmlobjects.gml.model.geometry.SRSInformation;
import org.xmlobjects.gml.model.geometry.SRSReference;
import org.xmlobjects.gml.model.valueobjects.ReferenceSystem;
import org.xmlobjects.gml.model.xlink.ActuateType;
import org.xmlobjects.gml.model.xlink.ShowType;
import org.xmlobjects.xml.Attributes;

public class GMLBuilderHelper {
    public static boolean isGMLNamespace(String namespaceURI) {
        return "http://www.opengis.net/gml/3.2".equals(namespaceURI) || "http://www.opengis.net/gml".equals(namespaceURI) || "http://www.opengis.net/gml/3.3/xbt".equals(namespaceURI) || "http://www.opengis.net/gml/3.3/ce".equals(namespaceURI);
    }

    public static void buildAssociationAttributes(AssociationAttributes object, Attributes attributes) {
        attributes.getValue("http://www.w3.org/1999/xlink", "href").ifPresent(object::setHref);
        attributes.getValue("http://www.w3.org/1999/xlink", "role").ifPresent(object::setRole);
        attributes.getValue("http://www.w3.org/1999/xlink", "arcrole").ifPresent(object::setArcRole);
        attributes.getValue("http://www.w3.org/1999/xlink", "title").ifPresent(object::setTitle);
        attributes.getValue("http://www.w3.org/1999/xlink", "show").ifPresent(v -> object.setShow(ShowType.fromValue(v)));
        attributes.getValue("http://www.w3.org/1999/xlink", "actuate").ifPresent(v -> object.setActuate(ActuateType.fromValue(v)));
        attributes.getValue("http://www.opengis.net/gml", "remoteSchema").ifPresent(object::setRemoteSchema);
        attributes.getValue("http://www.opengis.net/gml/3.2", "remoteSchema").ifPresent(object::setRemoteSchema);
        attributes.getValue("nilReason").ifPresent(v -> object.setNilReason(new NilReason((String)v)));
    }

    public static void buildOwnershipAttributes(OwnershipAttributes object, Attributes attributes) {
        attributes.getValue("owns").ifBoolean(object::setOwns);
    }

    public static void buildAggregationAttributes(AggregationAttributes object, Attributes attributes) {
        attributes.getValue("aggregationType").ifPresent(v -> object.setAggregationType(AggregationType.fromValue(v)));
    }

    public static void buildSRSReference(SRSReference object, Attributes attributes) {
        attributes.getValue("srsName").ifPresent(object::setSrsName);
        attributes.getValue("srsDimension").ifInteger(object::setSrsDimension);
        GMLBuilderHelper.buildSRSInformation(object, attributes);
    }

    public static void buildSRSInformation(SRSInformation object, Attributes attributes) {
        attributes.getValue("axisLabels").ifList(object::setAxisLabels);
        attributes.getValue("uomLabels").ifList(object::setAxisLabels);
    }

    public static void buildReferenceSystem(ReferenceSystem object, Attributes attributes) {
        attributes.getValue("codeSpace").ifPresent(object::setCodeSpace);
        attributes.getValue("uom").ifPresent(object::setUom);
    }
}

