/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlobjects.gml.model.GMLObject;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.geometry.SRSReference;

public class DirectPositionList
extends GMLObject
implements SRSReference,
CoordinateListProvider {
    private List<Double> value;
    private Integer count;
    private String srsName;
    private Integer srsDimension;
    private List<String> axisLabels;
    private List<String> uomLabels;

    public DirectPositionList() {
    }

    public DirectPositionList(List<Double> value) {
        this.value = value;
    }

    public DirectPositionList(double ... ordinates) {
        if (ordinates != null && ordinates.length > 0) {
            this.value = new ArrayList<Double>(ordinates.length);
            for (double ordinate : ordinates) {
                this.value.add(ordinate);
            }
        }
    }

    public List<Double> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        return this.value;
    }

    public boolean isSetValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public void setValue(List<Double> value) {
        this.value = value;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        if (count == null || count > 0) {
            this.count = count;
        }
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer srsDimension) {
        if (srsDimension == null || srsDimension > 0) {
            this.srsDimension = srsDimension;
        }
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public boolean isSetAxisLabels() {
        return this.axisLabels != null && !this.axisLabels.isEmpty();
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        this.axisLabels = axisLabels;
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public boolean isSetUomLabels() {
        return this.uomLabels != null && !this.uomLabels.isEmpty();
    }

    @Override
    public void setUomLabels(List<String> uomLabels) {
        this.uomLabels = uomLabels;
    }

    @Override
    public List<Double> toCoordinateList3D() {
        List<Double> coordinates = null;
        if (this.value != null && !this.value.isEmpty()) {
            int dim = 3;
            if (this.srsDimension != null) {
                dim = this.srsDimension;
            } else if (this.count != null) {
                dim = this.value.size() / this.count;
            } else {
                SRSReference srsReference = this.getInheritedSRSReference();
                if (srsReference.getSrsDimension() != null) {
                    dim = srsReference.getSrsDimension();
                }
            }
            int count = this.value.size() / dim;
            if (this.value.size() > count * dim) {
                ++count;
            }
            coordinates = new ArrayList<Double>(count * 3);
            for (int i = 0; i < this.value.size(); i += dim) {
                coordinates.add(this.value.get(i));
                coordinates.add(dim > 1 && i + 1 < this.value.size() ? this.value.get(i + 1) : 0.0);
                coordinates.add(dim > 2 && i + 2 < this.value.size() ? this.value.get(i + 2) : 0.0);
            }
        }
        return coordinates != null ? coordinates : Collections.emptyList();
    }
}

