/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.xmlobjects.gml.model.GMLObject;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.feature.AbstractFeature;
import org.xmlobjects.gml.model.geometry.DirectPosition;
import org.xmlobjects.gml.model.geometry.SRSReference;

public class Envelope
extends GMLObject
implements SRSReference,
CoordinateListProvider {
    private DirectPosition lowerCorner;
    private DirectPosition upperCorner;
    private String srsName;
    private Integer srsDimension;
    private List<String> axisLabels;
    private List<String> uomLabels;

    public Envelope() {
        this.setLowerCorner(new DirectPosition());
        this.setUpperCorner(new DirectPosition());
    }

    public Envelope(DirectPosition lowerCorner, DirectPosition upperCorner) {
        this.setLowerCorner(lowerCorner != null ? lowerCorner : new DirectPosition());
        this.setUpperCorner(upperCorner != null ? upperCorner : new DirectPosition());
    }

    public DirectPosition getLowerCorner() {
        return this.lowerCorner;
    }

    public boolean isSetLowerCorner() {
        return this.lowerCorner.isSetValue();
    }

    public void setLowerCorner(DirectPosition lowerCorner) {
        if (lowerCorner != null) {
            this.lowerCorner = this.asChild(lowerCorner);
        }
    }

    public DirectPosition getUpperCorner() {
        return this.upperCorner;
    }

    public boolean isSetUpperCorner() {
        return this.upperCorner.isSetValue();
    }

    public void setUpperCorner(DirectPosition upperCorner) {
        if (upperCorner != null) {
            this.upperCorner = this.asChild(upperCorner);
        }
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer srsDimension) {
        if (srsDimension == null || srsDimension > 0) {
            this.srsDimension = srsDimension;
        }
    }

    @Override
    public List<String> getAxisLabels() {
        return this.axisLabels;
    }

    @Override
    public boolean isSetAxisLabels() {
        return this.axisLabels != null && !this.axisLabels.isEmpty();
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        if (axisLabels == null) {
            axisLabels = new ArrayList<String>();
        }
        this.axisLabels = axisLabels;
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public boolean isSetUomLabels() {
        return this.uomLabels != null && !this.uomLabels.isEmpty();
    }

    @Override
    public void setUomLabels(List<String> uomLabels) {
        this.uomLabels = uomLabels;
    }

    public boolean isValid() {
        if (!this.lowerCorner.isSetValue() || !this.upperCorner.isSetValue() || this.lowerCorner.getValue().size() != this.upperCorner.getValue().size()) {
            return false;
        }
        for (int i = 0; i < this.lowerCorner.getValue().size(); ++i) {
            if (!(this.lowerCorner.getValue().get(i) > this.upperCorner.getValue().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getDimension(); ++i) {
            if (!(this.upperCorner.getValue().get(i) > this.lowerCorner.getValue().get(i))) continue;
            return false;
        }
        return true;
    }

    public int getDimension() {
        return this.isValid() ? this.lowerCorner.getValue().size() : 0;
    }

    public double getMinimum(int dimension) {
        if (dimension <= 0 || dimension > this.getDimension()) {
            throw new IndexOutOfBoundsException("Invalid dimension parameter.");
        }
        return this.lowerCorner.getValue().get(dimension - 1);
    }

    public double getMaximum(int dimension) {
        if (dimension <= 0 || dimension > this.getDimension()) {
            throw new IndexOutOfBoundsException("Invalid dimension parameter.");
        }
        return this.upperCorner.getValue().get(dimension - 1);
    }

    public double getMedian(int dimension) {
        if (dimension <= 0 || dimension > this.getDimension()) {
            throw new IndexOutOfBoundsException("Invalid dimension parameter.");
        }
        return (this.lowerCorner.getValue().get(dimension - 1) + this.upperCorner.getValue().get(dimension - 1)) / 2.0;
    }

    public double getSpan(int dimension) {
        if (dimension <= 0 || dimension > this.getDimension()) {
            throw new IndexOutOfBoundsException("Invalid dimension parameter.");
        }
        return this.upperCorner.getValue().get(dimension - 1) - this.lowerCorner.getValue().get(dimension - 1);
    }

    public DirectPosition getCenter() {
        DirectPosition center = null;
        if (this.isValid()) {
            center = new DirectPosition();
            for (int i = 0; i < this.lowerCorner.getValue().size(); ++i) {
                center.getValue().add((this.lowerCorner.getValue().get(i) + this.upperCorner.getValue().get(i)) / 2.0);
            }
        }
        return center;
    }

    public boolean contains(double ... ordinates) {
        return ordinates != null && this.contains(Arrays.stream(ordinates).boxed().collect(Collectors.toList()));
    }

    public boolean contains(List<Double> ordinates) {
        return ordinates != null && this.isValid() && ordinates.size() == this.lowerCorner.getValue().size() && this.contains(ordinates, ordinates);
    }

    public boolean contains(DirectPosition position) {
        return position != null && this.isValid() && position.getValue().size() == this.lowerCorner.getValue().size() && this.contains(position.getValue(), position.getValue());
    }

    public boolean contains(Envelope other) {
        return other != null && other.isValid() && this.contains(other.lowerCorner.getValue(), other.upperCorner.getValue());
    }

    private boolean contains(List<Double> lowerCorner, List<Double> upperCorner) {
        int dimension = Math.min(this.getDimension(), lowerCorner.size());
        if (dimension == 0) {
            return false;
        }
        for (int i = 0; i < dimension; ++i) {
            if (!(lowerCorner.get(i) < this.lowerCorner.getValue().get(i)) && !(upperCorner.get(i) > this.upperCorner.getValue().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(Envelope other) {
        return other != null && other.isValid() && this.intersects(other.lowerCorner.getValue(), other.upperCorner.getValue());
    }

    private boolean intersects(List<Double> lowerCorner, List<Double> upperCorner) {
        int dimension = Math.min(this.getDimension(), lowerCorner.size());
        if (dimension == 0) {
            return false;
        }
        for (int i = 0; i < dimension; ++i) {
            if (!(lowerCorner.get(i) > this.upperCorner.getValue().get(i)) && !(upperCorner.get(i) < this.lowerCorner.getValue().get(i))) continue;
            return false;
        }
        return true;
    }

    public Envelope include(double ... ordinates) {
        if (ordinates != null) {
            this.include(Arrays.stream(ordinates).boxed().collect(Collectors.toList()));
        }
        return this;
    }

    public Envelope include(List<Double> ordinates) {
        if (ordinates != null && !ordinates.isEmpty()) {
            this.include(ordinates, ordinates);
        }
        return this;
    }

    public Envelope include(DirectPosition position) {
        if (position != null && position.isSetValue()) {
            this.include(position.getValue(), position.getValue());
        }
        return this;
    }

    public Envelope include(Envelope other) {
        if (other != null && other.isValid()) {
            this.include(other.lowerCorner.getValue(), other.upperCorner.getValue());
        }
        return this;
    }

    private void include(List<Double> lowerCorner, List<Double> upperCorner) {
        if (!this.isValid()) {
            this.setLowerCorner(new DirectPosition(new ArrayList<Double>(lowerCorner)));
            this.setUpperCorner(new DirectPosition(new ArrayList<Double>(upperCorner)));
        } else {
            int dimension = this.getDimension();
            for (int i = 0; i < lowerCorner.size(); ++i) {
                double minimum = lowerCorner.get(i);
                double maximum = upperCorner.get(i);
                if (i < dimension) {
                    if (minimum < this.lowerCorner.getValue().get(i)) {
                        this.lowerCorner.getValue().set(i, minimum);
                    }
                    if (!(maximum > this.upperCorner.getValue().get(i))) continue;
                    this.upperCorner.getValue().set(i, maximum);
                    continue;
                }
                this.lowerCorner.getValue().add(minimum);
                this.upperCorner.getValue().add(maximum);
            }
        }
    }

    @Override
    public SRSReference getInheritedSRSReference() {
        if (this.srsName == null) {
            Envelope parent = this;
            while ((parent = parent.getParent()) != null) {
                AbstractFeature feature;
                if (!(parent instanceof AbstractFeature) || (feature = (AbstractFeature)((Object)parent)).getBoundedBy() == null || feature.getBoundedBy().getEnvelope() == null || feature.getBoundedBy().getEnvelope().getSrsName() == null) continue;
                return feature.getBoundedBy().getEnvelope();
            }
        }
        return this;
    }

    @Override
    public List<Double> toCoordinateList3D() {
        if (this.isValid()) {
            ArrayList<Double> coordinates = new ArrayList<Double>(6);
            coordinates.addAll(this.lowerCorner.toCoordinateList3D());
            coordinates.addAll(this.upperCorner.toCoordinateList3D());
            return coordinates;
        }
        return Collections.emptyList();
    }
}

