/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry.aggregates;

import java.util.List;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.Envelope;
import org.xmlobjects.gml.model.geometry.GeometryArrayProperty;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.model.geometry.aggregates.AbstractGeometricAggregate;
import org.xmlobjects.gml.visitor.GeometryVisitor;
import org.xmlobjects.gml.visitor.ObjectVisitor;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;

public class MultiGeometry
extends AbstractGeometricAggregate {
    private List<GeometryProperty<?>> geometryMember;
    private GeometryArrayProperty<?> geometryMembers;

    public MultiGeometry() {
    }

    public MultiGeometry(List<GeometryProperty<?>> geometryMember) {
        this.setGeometryMember(geometryMember);
    }

    public List<GeometryProperty<?>> getGeometryMember() {
        if (this.geometryMember == null) {
            this.geometryMember = new ChildList((Child)this);
        }
        return this.geometryMember;
    }

    public boolean isSetGeometryMember() {
        return this.geometryMember != null && !this.geometryMember.isEmpty();
    }

    public void setGeometryMember(List<GeometryProperty<?>> geometryMember) {
        this.geometryMember = this.asChild(geometryMember);
    }

    public GeometryArrayProperty<?> getGeometryMembers() {
        return this.geometryMembers;
    }

    public void setGeometryMembers(GeometryArrayProperty<?> geometryMembers) {
        this.geometryMembers = this.asChild(geometryMembers);
    }

    @Override
    public Envelope computeEnvelope() {
        Envelope envelope = new Envelope();
        if (this.geometryMember != null) {
            for (GeometryProperty<?> property : this.geometryMember) {
                if (property.getObject() == null) continue;
                envelope.include(property.getObject().computeEnvelope());
            }
        }
        if (this.geometryMembers != null && this.geometryMembers.isSetObjects()) {
            for (AbstractGeometry geometry : this.geometryMembers.getObjects()) {
                envelope.include(geometry.computeEnvelope());
            }
        }
        return envelope;
    }

    @Override
    public void accept(ObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

