/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry.complexes;

import java.util.List;
import org.xmlobjects.gml.model.base.AggregationAttributes;
import org.xmlobjects.gml.model.base.AggregationType;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.Envelope;
import org.xmlobjects.gml.model.geometry.primitives.AbstractGeometricPrimitive;
import org.xmlobjects.gml.model.geometry.primitives.GeometricPrimitiveProperty;
import org.xmlobjects.gml.visitor.GeometryVisitor;
import org.xmlobjects.gml.visitor.ObjectVisitor;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;

public class GeometricComplex
extends AbstractGeometry
implements AggregationAttributes {
    private List<GeometricPrimitiveProperty> elements;
    private AggregationType aggregationType;

    public GeometricComplex() {
    }

    public GeometricComplex(List<GeometricPrimitiveProperty> elements) {
        this.setElements(elements);
    }

    public List<GeometricPrimitiveProperty> getElements() {
        if (this.elements == null) {
            this.elements = new ChildList((Child)this);
        }
        return this.elements;
    }

    public boolean isSetElements() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void setElements(List<GeometricPrimitiveProperty> elements) {
        this.elements = this.asChild(elements);
    }

    @Override
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    @Override
    public Envelope computeEnvelope() {
        Envelope envelope = new Envelope();
        if (this.elements != null) {
            for (GeometricPrimitiveProperty property : this.elements) {
                if (property.getObject() == null) continue;
                envelope.include(((AbstractGeometricPrimitive)property.getObject()).computeEnvelope());
            }
        }
        return envelope;
    }

    @Override
    public void accept(ObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

