/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry.grids;

import java.util.List;
import org.xmlobjects.gml.model.geometry.Envelope;
import org.xmlobjects.gml.model.geometry.Vector;
import org.xmlobjects.gml.model.geometry.grids.Grid;
import org.xmlobjects.gml.model.geometry.primitives.Point;
import org.xmlobjects.gml.model.geometry.primitives.PointProperty;
import org.xmlobjects.gml.util.Matrices;
import org.xmlobjects.gml.util.jama.Matrix;
import org.xmlobjects.gml.visitor.GeometryVisitor;
import org.xmlobjects.gml.visitor.ObjectVisitor;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;

public class RectifiedGrid
extends Grid {
    private PointProperty origin;
    private List<Vector> offsetVectors;

    public PointProperty getOrigin() {
        return this.origin;
    }

    public void setOrigin(PointProperty origin) {
        this.origin = this.asChild(origin);
    }

    public List<Vector> getOffsetVectors() {
        if (this.offsetVectors == null) {
            this.offsetVectors = new ChildList((Child)this);
        }
        return this.offsetVectors;
    }

    public boolean isSetOffsetVectors() {
        return this.offsetVectors != null && !this.offsetVectors.isEmpty();
    }

    public void setOffsetVectors(List<Vector> offsetVectors) {
        this.offsetVectors = this.asChild(offsetVectors);
    }

    @Override
    public Envelope computeEnvelope() {
        Envelope gridEnvelope;
        int dimension;
        Envelope envelope = new Envelope();
        if (this.origin != null && this.origin.getObject() != null && this.offsetVectors != null && (dimension = (gridEnvelope = this.getLimits() != null && this.getLimits().getGridEnvelope() != null ? this.getLimits().getGridEnvelope().toEnvelope() : new Envelope()).getDimension()) > 0 && this.offsetVectors.size() >= dimension) {
            Matrix[] offsetVectors = new Matrix[]{Matrices.newMatrix(this.offsetVectors.get(0).toCoordinateList3D(), 3), dimension >= 2 ? Matrices.newMatrix(this.offsetVectors.get(1).toCoordinateList3D(), 3) : new Matrix(3, 1, 0.0), dimension >= 3 ? Matrices.newMatrix(this.offsetVectors.get(2).toCoordinateList3D(), 3) : new Matrix(3, 1, 0.0)};
            Matrix origin = Matrices.newMatrix(((Point)this.origin.getObject()).toCoordinateList3D(), 3);
            List<Double> limits = gridEnvelope.toCoordinateList3D();
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    for (int z = 0; z < 2; ++z) {
                        envelope.include(origin.plus(offsetVectors[0].times(limits.get(x * 3))).plus(offsetVectors[1].times(limits.get(1 + y * 3))).plus(offsetVectors[2].times(limits.get(2 + z * 3))).getColumnPackedCopy());
                    }
                }
            }
        }
        return envelope;
    }

    @Override
    public void accept(ObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

