/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.temporal;

import org.xmlobjects.gml.model.GMLObject;
import org.xmlobjects.gml.model.temporal.CalendarDate;
import org.xmlobjects.gml.model.temporal.CalenderDateType;
import org.xmlobjects.gml.model.temporal.ClockTime;
import org.xmlobjects.gml.model.temporal.DateAndTime;
import org.xmlobjects.gml.model.temporal.OrdinalPosition;
import org.xmlobjects.gml.model.temporal.TimeCoordinate;
import org.xmlobjects.gml.model.temporal.TimeIndeterminateValue;
import org.xmlobjects.gml.model.temporal.TimePositionValue;
import org.xmlobjects.xml.TextContent;

public class TimePosition
extends GMLObject {
    private TimePositionValue<?> value;
    private String frame;
    private String calendarEraName;
    private TimeIndeterminateValue indeterminatePosition;

    public TimePosition() {
    }

    public TimePosition(TimePositionValue<?> value) {
        this.value = value;
    }

    public TimePosition(String value) {
        this.setValue(value);
    }

    public TimePositionValue<?> getValue() {
        return this.value;
    }

    public void setValue(TimePositionValue<?> value) {
        this.value = value;
    }

    public void setValue(String value) {
        TextContent content = TextContent.of((String)value);
        this.value = content.isDateTime() ? new DateAndTime(content.getAsDateTime()) : (content.isTime() ? new ClockTime(content.getAsTime().toOffsetTime()) : (content.isDate() ? new CalendarDate(content.getAsDate(), CalenderDateType.DATE) : (content.isGYear() ? new CalendarDate(content.getAsGYear(), CalenderDateType.YEAR) : (content.isGYearMonth() ? new CalendarDate(content.getAsGYearMonth(), CalenderDateType.YEAR_MONTH) : (content.isDouble() ? new TimeCoordinate(content.getAsDouble()) : new OrdinalPosition(value))))));
    }

    public String getFrame() {
        return this.frame != null ? this.frame : "#ISO-8601";
    }

    public boolean isSetFrame() {
        return this.frame != null;
    }

    public void setFrame(String frame) {
        this.frame = frame;
    }

    public String getCalendarEraName() {
        return this.calendarEraName;
    }

    public void setCalendarEraName(String calendarEraName) {
        this.calendarEraName = calendarEraName;
    }

    public TimeIndeterminateValue getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public void setIndeterminatePosition(TimeIndeterminateValue indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition;
    }

    public CalendarDate asCalendarDate() {
        return this.isCalendarDate() ? (CalendarDate)this.value : null;
    }

    public boolean isCalendarDate() {
        return this.value instanceof CalendarDate;
    }

    public ClockTime asClockTime() {
        return this.isClockTime() ? (ClockTime)this.value : null;
    }

    public boolean isClockTime() {
        return this.value instanceof ClockTime;
    }

    public DateAndTime asDateAndTime() {
        return this.isDateAndTime() ? (DateAndTime)this.value : null;
    }

    public boolean isDateAndTime() {
        return this.value instanceof DateAndTime;
    }

    public OrdinalPosition asOrdinalPosition() {
        return this.isOrdinalPosition() ? (OrdinalPosition)this.value : null;
    }

    public boolean isOrdinalPosition() {
        return this.value instanceof OrdinalPosition;
    }

    public TimeCoordinate asTimeCoordinate() {
        return this.isTimeCoordinate() ? (TimeCoordinate)this.value : null;
    }

    public boolean isTimeCoordinate() {
        return this.value instanceof TimeCoordinate;
    }
}

