/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.util.id;

import java.util.UUID;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.util.xml.XMLPatterns;

public class DefaultIdCreator
implements IdCreator {
    private static DefaultIdCreator instance;
    private String prefix = this.getDefaultPrefix();

    private DefaultIdCreator() {
    }

    public static synchronized DefaultIdCreator getInstance() {
        if (instance == null) {
            instance = new DefaultIdCreator();
        }
        return instance;
    }

    public static DefaultIdCreator newInstance(String prefix) {
        return new DefaultIdCreator().withPrefix(prefix);
    }

    public String getDefaultPrefix() {
        return "ID_";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isValidPrefix(String prefix) {
        return prefix != null && XMLPatterns.NCNAME.matcher(prefix).matches();
    }

    public DefaultIdCreator withPrefix(String prefix) {
        this.prefix = this.isValidPrefix(prefix) ? prefix : this.getDefaultPrefix();
        return this;
    }

    @Override
    public String createId() {
        return this.prefix + UUID.randomUUID();
    }
}

